/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.entity.client.renderer;

import com.google.gson.JsonElement;
import com.merlin204.tde.entity.player.TDELocalPlayerPatch;
import com.merlin204.tde.epicfight.gameassets.skill.sect.basic.BasicSect;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.renderer.patched.item.RenderItemBase;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class RenderMeshItem
extends RenderItemBase {
    private final ResourceLocation texture;
    private final AssetAccessor<? extends SkinnedMesh> mesh_main;
    private final AssetAccessor<? extends SkinnedMesh> mesh_off;
    private final AssetAccessor<? extends SkinnedMesh> mesh_main_b;
    private final AssetAccessor<? extends SkinnedMesh> mesh_off_b;

    public RenderMeshItem(JsonElement jsonElement) {
        super(jsonElement);
        if (jsonElement.getAsJsonObject().has("id")) {
            String id = jsonElement.getAsJsonObject().get("id").getAsString();
            this.texture = ResourceLocation.parse((String)("tde:textures/item/weapon/" + id + ".png"));
            this.mesh_main = Meshes.MeshAccessor.create((String)ResourceLocation.parse((String)("tde:item/weapon/" + id + "_main")).m_135827_(), (String)ResourceLocation.parse((String)("tde:item/weapon/" + id + "_main")).m_135815_(), loader -> loader.loadSkinnedMesh(SkinnedMesh::new));
            this.mesh_off = Meshes.MeshAccessor.create((String)ResourceLocation.parse((String)("tde:item/weapon/" + id + "_off")).m_135827_(), (String)ResourceLocation.parse((String)("tde:item/weapon/" + id + "_off")).m_135815_(), loader -> loader.loadSkinnedMesh(SkinnedMesh::new));
            this.mesh_main_b = Meshes.MeshAccessor.create((String)ResourceLocation.parse((String)("tde:item/weapon/" + id + "_main_b")).m_135827_(), (String)ResourceLocation.parse((String)("tde:item/weapon/" + id + "_main_b")).m_135815_(), loader -> loader.loadSkinnedMesh(SkinnedMesh::new));
            this.mesh_off_b = Meshes.MeshAccessor.create((String)ResourceLocation.parse((String)("tde:item/weapon/" + id + "_off_b")).m_135827_(), (String)ResourceLocation.parse((String)("tde:item/weapon/" + id + "_off_b")).m_135815_(), loader -> loader.loadSkinnedMesh(SkinnedMesh::new));
        } else {
            this.texture = null;
            this.mesh_main = null;
            this.mesh_off = null;
            this.mesh_main_b = null;
            this.mesh_off_b = null;
        }
    }

    public void renderItemInHand(ItemStack stack, LivingEntityPatch<?> entitypatch, InteractionHand hand, OpenMatrix4f[] poses, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        TDELocalPlayerPatch localPlayerPatch;
        SkillContainer skillContainer;
        Skill skill;
        SkinnedMesh renderMesh = null;
        if (hand == InteractionHand.MAIN_HAND) {
            renderMesh = (SkinnedMesh)this.mesh_main.get();
        } else if (hand == InteractionHand.OFF_HAND) {
            renderMesh = (SkinnedMesh)this.mesh_off.get();
        }
        if (entitypatch instanceof TDELocalPlayerPatch && (skill = (skillContainer = (localPlayerPatch = (TDELocalPlayerPatch)entitypatch).getSkill(TDESkillSlots.SECT)).getSkill()) instanceof BasicSect) {
            BasicSect basicSect = (BasicSect)skill;
            if (!basicSect.checkAllowed((Player)localPlayerPatch.getOriginal())) {
                if (hand == InteractionHand.MAIN_HAND) {
                    renderMesh = (SkinnedMesh)this.mesh_main_b.get();
                } else if (hand == InteractionHand.OFF_HAND) {
                    renderMesh = (SkinnedMesh)this.mesh_off_b.get();
                }
            }
            if (hand == InteractionHand.MAIN_HAND && localPlayerPatch.mainBackTick > 0) {
                renderMesh = (SkinnedMesh)this.mesh_main_b.get();
            } else if (hand == InteractionHand.OFF_HAND && localPlayerPatch.offBackTick > 0) {
                renderMesh = (SkinnedMesh)this.mesh_off_b.get();
            }
        }
        Armature armature = entitypatch.getArmature();
        poseStack.m_85836_();
        if (renderMesh != null) {
            renderMesh.draw(poseStack, buffer, RenderType.m_110473_((ResourceLocation)this.texture), packedLight, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, entitypatch.getArmature(), armature.getPoseMatrices());
        }
        poseStack.m_85849_();
    }
}

