/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.entity.boss.b2;

import com.merlin204.tde.entity.ai.SmartChaseGoal;
import com.merlin204.tde.entity.ai.TDEAnimatedAttackGoal;
import com.merlin204.tde.entity.boss.BossPatch;
import com.merlin204.tde.entity.boss.b2.B2Animations;
import com.merlin204.tde.entity.boss.b2.ai.B2CombatBehaviors;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.enemy.EnemyPatch;
import com.merlin204.tde.util.TDEAnimationUtils;
import com.merlin204.tde.world.AtkDirection;
import com.merlin204.tde.world.TDEDamageSource;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class B2Patch
extends BossPatch {
    protected void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation((LivingMotion)LivingMotions.IDLE, B2Animations.IDLE);
        animator.addLivingAnimation((LivingMotion)LivingMotions.WALK, B2Animations.WALK);
        animator.addLivingAnimation((LivingMotion)LivingMotions.DEATH, B2Animations.HIT_M);
    }

    protected void initAI() {
        super.initAI();
        ((EnemyEntity)this.original).f_21345_.m_25352_(0, new TDEAnimatedAttackGoal<EnemyPatch>(this, B2CombatBehaviors.TYPE1.build(this)));
        ((EnemyEntity)this.original).f_21345_.m_25352_(1, (Goal)new SmartChaseGoal(this, 2.0f, 0.3f));
    }

    @Override
    public void tick(LivingEvent.LivingTickEvent event) {
        super.tick(event);
    }

    @Override
    public AssetAccessor<? extends StaticAnimation> getTDEhitAnimation(TDEDamageSource damageSource) {
        AtkDirection atkDirection = damageSource.getAtkDirection();
        if (((EnemyEntity)this.original).isKnockdown()) {
            return null;
        }
        switch (atkDirection) {
            case LEFT: {
                return B2Animations.HIT_L;
            }
            case RIGHT: {
                return B2Animations.HIT_R;
            }
            case MIDDLE: {
                return B2Animations.HIT_M;
            }
        }
        return B2Animations.HIT_M;
    }

    @Override
    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getKnockdownAnimation() {
        return B2Animations.KNOCKDOWN;
    }

    @Override
    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getKnockFlyAnimation() {
        return B2Animations.KNOCKFLY;
    }

    @Override
    public void poseTick(DynamicAnimation animation, Pose pose, float elapsedTime, float partialTicks) {
        if (((EnemyEntity)this.original).getHitTick() > 0) {
            float ratio = (float)((EnemyEntity)this.original).getHitTick() / 20.0f;
            TDEAnimationUtils.joinRotationInPose(pose, (LivingEntityPatch)this, "body", 10.0f * ratio, 0.0f, -10.0f * ratio);
            TDEAnimationUtils.joinRotationInPose(pose, (LivingEntityPatch)this, "head", -10.0f * ratio, 0.0f, 10.0f * ratio);
        }
    }

    @Override
    public SoundEvent getSwingSound(InteractionHand hand) {
        return (SoundEvent)EpicFightSounds.WHOOSH.get();
    }

    @Override
    public SoundEvent getWeaponHitSound(InteractionHand hand) {
        return (SoundEvent)EpicFightSounds.BLADE_HIT.get();
    }

    public HitParticleType getWeaponHitParticle(InteractionHand hand) {
        return (HitParticleType)EpicFightParticles.HIT_BLADE.get();
    }
}

