/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.entity.boss;

import com.merlin204.tde.block.fogblock.FogBlock;
import com.merlin204.tde.client.gui.TDEBossBar;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.network.NetworkHandler;
import com.merlin204.tde.network.SyncBossBarPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class BossEntity
extends EnemyEntity {
    protected static final EntityDataAccessor<Integer> LEVEL = SynchedEntityData.m_135353_(BossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected final ServerBossEvent bossEvent = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS);

    protected BossEntity(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public boolean m_6094_() {
        return false;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(LEVEL, (Object)1);
    }

    public int getLevel() {
        return (Integer)this.f_19804_.m_135370_(LEVEL);
    }

    public void setLevel(int level) {
        this.f_19804_.m_135381_(LEVEL, (Object)level);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Level", ((Integer)this.f_19804_.m_135370_(LEVEL)).intValue());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Level")) {
            this.f_19804_.m_135381_(LEVEL, (Object)tag.m_128451_("Level"));
        }
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossEvent.m_6543_(player);
        NetworkHandler.sendToClient(new SyncBossBarPacket(this.bossEvent.m_18860_(), this.m_19879_()), player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossEvent.m_6539_(player);
        TDEBossBar.BOSSES.remove(this.bossEvent.m_18860_());
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    @Override
    public void m_142687_(Entity.RemovalReason pReason) {
        Level level;
        if (pReason == Entity.RemovalReason.KILLED && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos playerPos = this.m_20183_();
            int radius = 50;
            Vec3 Pos = this.m_20182_();
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        BlockPos pos = playerPos.m_7918_(x, y, z);
                        Vec3 blockCenter = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                        Vec3 toBlock = blockCenter.m_82546_(Pos);
                        double distanceSq = toBlock.m_82556_();
                        if (distanceSq < 1.0E-4) continue;
                        Vec3 direction = toBlock.m_82541_();
                        Block block = serverLevel.m_8055_(pos).m_60734_();
                        if (!(block instanceof FogBlock)) continue;
                        FogBlock fogBlock = (FogBlock)block;
                        fogBlock.clearSurroundingBarriers(serverLevel, pos, 30);
                    }
                }
            }
        }
        super.m_142687_(pReason);
    }
}

