/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.entity.boss.B1;

import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXHelper;
import com.merlin204.tde.entity.ai.TDEAnimatedAttackGoal;
import com.merlin204.tde.entity.ai.WonderGoal;
import com.merlin204.tde.entity.boss.B1.B1Animations;
import com.merlin204.tde.entity.boss.B1.ai.B1CombatBehaviors;
import com.merlin204.tde.entity.boss.BossPatch;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.enemy.EnemyPatch;
import com.merlin204.tde.epicfight.api.animation.TDELivingMotions;
import com.merlin204.tde.photon.JointEffect;
import com.merlin204.tde.util.TDEAnimationUtils;
import com.merlin204.tde.world.AtkDirection;
import com.merlin204.tde.world.TDEDamageSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class B1Patch
extends BossPatch {
    protected void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation((LivingMotion)LivingMotions.IDLE, B1Animations.B1_IDLE);
        animator.addLivingAnimation((LivingMotion)LivingMotions.WALK, B1Animations.B1_IDLE);
        animator.addLivingAnimation((LivingMotion)LivingMotions.DEATH, B1Animations.B1_HIT_M);
        animator.addLivingAnimation((LivingMotion)TDELivingMotions.WONDER_R, B1Animations.B1_WONDER_R);
    }

    protected void initAI() {
        super.initAI();
        ((EnemyEntity)this.original).f_21345_.m_25352_(0, new TDEAnimatedAttackGoal<EnemyPatch>(this, B1CombatBehaviors.TYPE1.build(this)));
        ((EnemyEntity)this.original).f_21345_.m_25352_(1, (Goal)new WonderGoal(this, 60.0f, false));
    }

    @Override
    public void tick(LivingEvent.LivingTickEvent event) {
        super.tick(event);
        boolean upPos = true;
        if (!this.getEntityState().canBasicAttack()) {
            upPos = false;
        }
        if (((EnemyEntity)this.original).m_9236_().f_46443_) {
            FX fx = FXHelper.getFX((ResourceLocation)new ResourceLocation("photon:b1/b1_soulfire"));
            if (fx == null) {
                return;
            }
            new JointEffect(fx, ((EnemyEntity)this.original).m_9236_(), this.original, this.getArmature().searchJointByName("chest"), new Vec3f(0.0, 0.1, -0.15), 3, upPos, true).start();
        }
    }

    @Override
    public AssetAccessor<? extends StaticAnimation> getTDEhitAnimation(TDEDamageSource damageSource) {
        AtkDirection atkDirection = damageSource.getAtkDirection();
        if (((EnemyEntity)this.original).isKnockdown()) {
            return null;
        }
        switch (atkDirection) {
            case LEFT: {
                return B1Animations.B1_HIT_L;
            }
            case RIGHT: {
                return B1Animations.B1_HIT_R;
            }
            case MIDDLE: {
                return B1Animations.B1_HIT_M;
            }
        }
        return B1Animations.B1_HIT_M;
    }

    @Override
    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getKnockdownAnimation() {
        return B1Animations.B1_KNOCKDOWN;
    }

    @Override
    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getKnockFlyAnimation() {
        return B1Animations.B1_KNOCKFLY;
    }

    @Override
    public void poseTick(DynamicAnimation animation, Pose pose, float elapsedTime, float partialTicks) {
        if (((EnemyEntity)this.original).getHitTick() > 0) {
            float ratio = (float)((EnemyEntity)this.original).getHitTick() / 20.0f;
            TDEAnimationUtils.joinRotationInPose(pose, (LivingEntityPatch)this, "body", 10.0f * ratio, 0.0f, -10.0f * ratio);
            TDEAnimationUtils.joinRotationInPose(pose, (LivingEntityPatch)this, "head", -10.0f * ratio, 0.0f, 10.0f * ratio);
        }
    }

    @Override
    public SoundEvent getSwingSound(InteractionHand hand) {
        return (SoundEvent)EpicFightSounds.WHOOSH_BIG.get();
    }

    @Override
    public SoundEvent getWeaponHitSound(InteractionHand hand) {
        return (SoundEvent)EpicFightSounds.BLADE_HIT.get();
    }

    public HitParticleType getWeaponHitParticle(InteractionHand hand) {
        return (HitParticleType)EpicFightParticles.HIT_BLADE.get();
    }
}

