/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.entity.ai;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TargetSelector
extends TargetGoal {
    private static final int DEFAULT_RANDOM_INTERVAL = 10;
    protected final int randomInterval;
    @Nullable
    protected Player targetPlayer;
    protected TargetingConditions targetConditions;
    private final float lockAngle;
    private final double maxLockDistance;
    private boolean isLocked = false;

    public TargetSelector(Mob mob, float lockAngle, double maxLockDistance) {
        this(mob, lockAngle, maxLockDistance, 10, true);
    }

    public TargetSelector(Mob mob, float lockAngle, double maxLockDistance, int randomInterval, boolean mustSee) {
        super(mob, mustSee, false);
        this.lockAngle = lockAngle;
        this.maxLockDistance = maxLockDistance;
        this.randomInterval = TargetSelector.m_186073_((int)randomInterval);
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        this.targetConditions = TargetingConditions.m_148352_().m_26883_(maxLockDistance).m_26893_();
    }

    protected double m_7623_() {
        return this.maxLockDistance;
    }

    public boolean m_8036_() {
        if (this.randomInterval > 0 && this.f_26135_.m_217043_().m_188503_(this.randomInterval) != 0) {
            return false;
        }
        this.targetPlayer = this.findSuitablePlayer();
        if (this.targetPlayer != null) {
            this.isLocked = true;
            return true;
        }
        return false;
    }

    @Nullable
    private Player findSuitablePlayer() {
        List players = this.f_26135_.m_9236_().m_6907_();
        Vec3 eyePosition = this.f_26135_.m_146892_();
        Vec3 viewVector = this.f_26135_.m_20252_(1.0f);
        return players.stream().filter(LivingEntity::m_6084_).filter(player -> {
            double distanceSq = eyePosition.m_82557_(player.m_20182_());
            return distanceSq <= this.maxLockDistance * this.maxLockDistance;
        }).filter(player -> {
            double requiredDot;
            Vec3 toPlayer = player.m_146892_().m_82546_(eyePosition).m_82541_();
            double dot = viewVector.m_82526_(toPlayer);
            return dot >= (requiredDot = Math.cos(Math.toRadians(this.lockAngle / 2.0f)));
        }).filter(player -> {
            Vec3 playerEyePos = player.m_146892_();
            ClipContext context = new ClipContext(eyePosition, playerEyePos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.f_26135_);
            return this.f_26135_.m_9236_().m_45547_(context).m_6662_() == HitResult.Type.MISS;
        }).min(Comparator.comparingDouble(player -> eyePosition.m_82557_(player.m_20182_()))).orElse(null);
    }

    public void m_8056_() {
        if (this.targetPlayer != null) {
            this.f_26135_.m_6710_((LivingEntity)this.targetPlayer);
        }
        super.m_8056_();
    }

    public boolean m_8045_() {
        if (this.isLocked && this.targetPlayer != null) {
            if (!this.targetPlayer.m_6084_()) {
                return false;
            }
            double distanceSq = this.f_26135_.m_20280_((Entity)this.targetPlayer);
            return !(distanceSq > this.maxLockDistance * this.maxLockDistance);
        }
        return super.m_8045_();
    }

    public void m_8041_() {
        this.targetPlayer = null;
        this.isLocked = false;
        super.m_8041_();
    }
}

