/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.entity.ai;

import com.merlin204.tde.entity.ai.TDECombatBehaviors;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.enemy.EnemyPatch;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;

public class TDEAnimatedAttackGoal<T extends MobPatch<?>>
extends Goal {
    protected final T mobpatch;
    protected final TDECombatBehaviors<T> combatBehaviors;
    private LivingEntity lastTarget;

    public TDEAnimatedAttackGoal(T mobpatch, TDECombatBehaviors<T> combatBehaviors) {
        this.mobpatch = mobpatch;
        this.combatBehaviors = combatBehaviors;
        this.lastTarget = null;
    }

    public boolean m_8036_() {
        return true;
    }

    public void m_8056_() {
        this.lastTarget = this.mobpatch.getTarget();
    }

    public void m_8037_() {
        TDECombatBehaviors.Behavior<T> result;
        LivingEntity currentTarget = this.mobpatch.getTarget();
        if (currentTarget != this.lastTarget) {
            this.resetCombatState();
            this.lastTarget = currentTarget;
        }
        if (currentTarget == null) {
            return;
        }
        EntityState state = this.mobpatch.getEntityState();
        this.combatBehaviors.tick();
        if (this.combatBehaviors.hasActivatedMove()) {
            TDECombatBehaviors.Behavior<T> result2;
            if (state.canBasicAttack() && (result2 = this.combatBehaviors.tryProceed()) != null) {
                result2.execute(this.mobpatch);
            }
        } else if (!state.inaction() && (result = this.combatBehaviors.selectRandomBehaviorSeries()) != null) {
            result.execute(this.mobpatch);
        }
    }

    private void resetCombatState() {
        TDECombatBehaviors.BehaviorSeries<T> currentSeries = this.combatBehaviors.getCurrentBehaviorSeries();
        this.combatBehaviors.stopCurrentBehavior();
    }

    protected boolean checkTargetValid() {
        Player player;
        EnemyPatch enemyPatch;
        T t = this.mobpatch;
        if (t instanceof EnemyPatch && ((EnemyEntity)(enemyPatch = (EnemyPatch)((Object)t)).getOriginal()).getStopEnergyRecoverTick() > 50) {
            return false;
        }
        LivingEntity livingentity = this.mobpatch.getTarget();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        return !(livingentity instanceof Player) || !(player = (Player)livingentity).m_5833_() && !player.m_7500_();
    }

    public void m_8041_() {
        this.lastTarget = null;
        this.resetCombatState();
    }
}

