/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.entity.ai;

import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.enemy.EnemyPatch;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class SmartChaseGoal
extends Goal {
    private final EnemyPatch entityPatch;
    private final PathfinderMob mob;
    private final double speedModifier;
    private final int searchRange;
    private final int verticalSearchRange;
    private final int recalculateInterval = 20;
    private final float minDistance;
    private int recalculateCooldown = 0;
    private BlockPos targetPos;
    private Path currentPath;
    private int pathIndex;
    private int losCheckCounter = 0;
    private boolean hasDirectLineOfSight = false;

    public SmartChaseGoal(EnemyPatch enemyPatch, float minDistance, double speedModifier) {
        this(enemyPatch, minDistance, speedModifier * (double)0.1f, 30, 1);
    }

    public SmartChaseGoal(EnemyPatch enemyPatch, float minDistance, double speedModifier, int searchRange, int verticalSearchRange) {
        this.entityPatch = enemyPatch;
        this.mob = (PathfinderMob)enemyPatch.getOriginal();
        this.speedModifier = speedModifier;
        this.searchRange = searchRange;
        this.verticalSearchRange = verticalSearchRange;
        this.minDistance = minDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.entityPatch.getEntityState().inaction() || this.entityPatch.getTarget() == null || !this.entityPatch.getTarget().m_6084_()) {
            return false;
        }
        double distanceSq = this.mob.m_20280_((Entity)this.entityPatch.getTarget());
        return distanceSq > (double)(this.minDistance * this.minDistance) && distanceSq < (double)(this.searchRange * this.searchRange);
    }

    public boolean m_8045_() {
        return !this.entityPatch.getEntityState().inaction() && this.entityPatch.getTarget() != null && this.entityPatch.getTarget().m_6084_() && this.mob.m_20280_((Entity)this.entityPatch.getTarget()) < (double)(this.searchRange * this.searchRange);
    }

    public void m_8056_() {
        this.hasDirectLineOfSight = false;
        this.losCheckCounter = 0;
        this.recalculateCooldown = 0;
        this.updateTargetPosition();
        this.createPathToTarget();
        this.startNavigation();
    }

    public void m_8041_() {
        this.mob.m_21573_().m_26573_();
        this.mob.m_21566_().m_6849_(this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), 0.0);
        this.currentPath = null;
    }

    public void m_8037_() {
        LivingEntity target = this.entityPatch.getTarget();
        if (target == null) {
            return;
        }
        ((EnemyEntity)this.entityPatch.getOriginal()).setGuardTick(0);
        ((EnemyEntity)this.entityPatch.getOriginal()).setWonderTick(0);
        this.updateTargetPosition();
        this.checkLineOfSight();
        if (this.hasDirectLineOfSight) {
            this.directChase(target);
        } else {
            this.pathBasedChase();
        }
        this.entityPatch.rotateTo((Entity)target, 5.0f, true);
    }

    private void updateTargetPosition() {
        if (this.entityPatch.getTarget() != null) {
            this.targetPos = this.entityPatch.getTarget().m_20183_();
        }
    }

    private void checkLineOfSight() {
        if (this.losCheckCounter-- <= 0) {
            this.losCheckCounter = 10;
            this.hasDirectLineOfSight = this.mob.m_142582_((Entity)this.entityPatch.getTarget());
        }
    }

    private void directChase(LivingEntity target) {
        double dz;
        double dx;
        double horizontalDistanceSq;
        double horizontalDistance;
        if (this.mob.m_21573_().m_26572_()) {
            this.mob.m_21573_().m_26573_();
        }
        if ((horizontalDistance = Math.sqrt(horizontalDistanceSq = (dx = target.m_20185_() - this.mob.m_20185_()) * dx + (dz = target.m_20189_() - this.mob.m_20189_()) * dz)) < (double)this.minDistance) {
            this.mob.m_20256_(new Vec3(0.0, this.mob.m_20184_().f_82480_, 0.0));
            return;
        }
        Vec3 horizontalDirection = new Vec3(dx / horizontalDistance, 0.0, dz / horizontalDistance).m_82490_(this.speedModifier * 1.5);
        Vec3 newVelocity = new Vec3(horizontalDirection.f_82479_, this.mob.m_20184_().f_82480_, horizontalDirection.f_82481_);
        this.mob.m_20256_(newVelocity);
    }

    private void pathBasedChase() {
        if (this.recalculateCooldown > 0) {
            --this.recalculateCooldown;
            return;
        }
        if (this.shouldRecalculatePath()) {
            this.createPathToTarget();
            this.startNavigation();
            this.recalculateCooldown = 20;
        }
        if (this.mob.m_21573_().m_26571_()) {
            this.createPathToTarget();
            this.startNavigation();
        }
    }

    private boolean shouldRecalculatePath() {
        if (this.entityPatch.getTarget() == null || this.targetPos == null) {
            return false;
        }
        if (this.targetPos.m_123331_((Vec3i)this.entityPatch.getTarget().m_20183_()) > 4.0) {
            return true;
        }
        if (this.mob.m_21573_().m_26570_() == null) {
            return true;
        }
        return !this.mob.m_21573_().m_26570_().m_77403_();
    }

    private void createPathToTarget() {
        BlockPos adjustedPos;
        if (this.targetPos == null) {
            return;
        }
        this.currentPath = this.mob.m_21573_().m_7864_(this.targetPos, 0);
        if (!(this.currentPath != null && this.currentPath.m_77403_() || (adjustedPos = this.findNearbyReachablePosition(this.targetPos)) == null)) {
            this.currentPath = this.mob.m_21573_().m_7864_(adjustedPos, 0);
        }
    }

    private void startNavigation() {
        if (this.currentPath != null) {
            this.mob.m_21573_().m_26536_(this.currentPath, this.speedModifier);
        }
    }

    private BlockPos findNearbyReachablePosition(BlockPos target) {
        for (int x = -2; x <= 2; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    Path testPath;
                    BlockPos testPos = target.m_7918_(x, y, z);
                    if (!this.isValidPosition(this.mob.m_9236_(), testPos) || (testPath = this.mob.m_21573_().m_7864_(testPos, 0)) == null || !testPath.m_77403_()) continue;
                    return testPos;
                }
            }
        }
        return null;
    }

    protected boolean isValidPosition(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60804_((BlockGetter)level, pos) && level.m_8055_(pos.m_7494_()).m_60795_() && level.m_8055_(pos.m_6630_(2)).m_60795_();
    }

    public boolean m_183429_() {
        return true;
    }
}

