/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.client.hud;

import com.merlin204.tde.capabilitiy.player.TDEPlayerCapabilities;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.capabilitiy.player.ability.PlayerAttribute;
import com.merlin204.tde.client.hud.TDEHudID;
import com.merlin204.tde.client.keymapping.TDEKeyMappings;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.player.TDELocalPlayerPatch;
import com.merlin204.tde.epicfight.gameassets.skill.SkillInfo;
import com.merlin204.tde.epicfight.gameassets.skill.cycle.CycleSkill;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import com.merlin204.tde.util.TDEAbilityUtils;
import com.merlin204.tde.util.TDEUIUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.NamedGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Matrix4f;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class TDEHud {
    public static TDEHud instance;
    private static final int SOUL_CHANGE_DURATION = 80;
    private static final int KEY_HINTS_RIGHT_MARGIN = 10;
    private static final int KEY_HINTS_BOTTOM_MARGIN = 30;
    private static final int KEY_HINTS_LINE_HEIGHT = 12;
    private static final int SOUL_FIRE_POS_X = 10;
    private static final int BAR_Y_POS_OFFSET = 60;
    private static final int BAR_SHORT_WIDTH = 128;
    private static final int BAR_SHORT_HEIGHT = 5;
    private static final int BAR_LONG_WIDTH = 256;
    private static final int BAR_LONG_HEIGHT = 16;
    private static final int AIR_BAR_POS_Y_OFFSET = 45;
    private static final int AIR_BAR_CUT_BASE = 123;
    private static final int AIR_BAR_MAX = 300;
    private static final int SOUL_COUNT_X = 120;
    private static final int SOUL_COUNT_Y = 20;
    private static final int SKILL_Y_POS_OFFSET = 46;
    private static final int SKILL_SLOT_SPACING = 30;
    private static final int COOLDOWN_OVERLAY_R = 32;
    private static final int COOLDOWN_OVERLAY_G = 32;
    private static final int COOLDOWN_OVERLAY_B = 32;
    private static final int COOLDOWN_OVERLAY_A = 128;
    private static final int SOUL_FIRE_WIDTH = 64;
    private static final int SOUL_FIRE_HEIGHT = 64;
    private static final int SOUL_FIRE_TEX_WIDTH = 1280;
    private static final int SOUL_FIRE_TEX_HEIGHT = 256;
    private static final int LOCK_ON_SIZE = 15;
    private static final int SKILL_SIZE = 24;
    private static final int SKILL_ICON_SIZE = 20;
    private static final int SKILL_ICON_PADDING = 2;
    private static final int NUMBER_TEX_WIDTH = 80;
    private static final int NUMBER_TEX_HEIGHT = 19;
    private static final int LEARN_SKILL_DURATION = 500;
    private static final int LEARN_SKILL_FADE_IN = 60;
    private static final int LEARN_SKILL_FADE_OUT = 60;
    private static final int LEARN_SKILL_POS_Y_OFFSET = 50;
    private static final int LEARN_SKILL_SIZE = 50;
    private static final int LEARN_SKILL_ICON_SIZE = 48;
    private static final List<Pair<String, KeyMapping>> KEY_HINTS;
    Minecraft minecraft = Minecraft.m_91087_();
    private float renderhealth;
    private float renderenergy;
    private float rendermana;
    private float lastSoulValue = -1.0f;
    private float soulChangeValue = 0.0f;
    private int soulChangeTimer = 0;
    private int learnSkillTimer = -1;
    private boolean isLearningSkill = false;
    private Skill learningSkill = null;

    public TDEHud() {
        instance = this;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void disableDefaultOverlay(RenderGuiOverlayEvent.Pre event) {
        NamedGuiOverlay overlay = event.getOverlay();
        if (overlay.id().equals((Object)VanillaGuiOverlay.ITEM_NAME.id()) || overlay.id().equals((Object)VanillaGuiOverlay.ARMOR_LEVEL.id()) || overlay.id().equals((Object)VanillaGuiOverlay.AIR_LEVEL.id()) || overlay.id().equals((Object)VanillaGuiOverlay.EXPERIENCE_BAR.id()) || overlay.id().equals((Object)VanillaGuiOverlay.POTION_ICONS.id()) || overlay.id().equals((Object)VanillaGuiOverlay.FOOD_LEVEL.id()) || overlay.id().equals((Object)VanillaGuiOverlay.PLAYER_HEALTH.id()) || overlay.id().equals((Object)VanillaGuiOverlay.MOUNT_HEALTH.id()) || overlay.id().equals((Object)VanillaGuiOverlay.JUMP_BAR.id())) {
            event.setCanceled(true);
        }
    }

    public void showLearnSkill(Skill skill) {
        this.learnSkillTimer = 0;
        this.isLearningSkill = true;
        this.learningSkill = skill;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void renderOverlay(RenderGuiEvent.Post event) {
        LocalPlayer player = this.minecraft.f_91074_;
        Window scaled = this.minecraft.m_91268_();
        if (player == null) {
            return;
        }
        if (this.minecraft.f_91074_ != null) {
            GlStateManager._clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TDELocalPlayerPatch playerPatch = (TDELocalPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, TDELocalPlayerPatch.class);
            if (playerPatch != null) {
                if (playerPatch.isEpicFightMode()) {
                    if (player.m_5842_()) {
                        this.getPlayerAirBar(player, scaled, event.getGuiGraphics());
                    } else {
                        this.learnSkill(player, scaled, event.getGuiGraphics());
                        this.renderKeyHints(scaled, event.getGuiGraphics());
                        this.renderSoulCount(player, scaled, event.getGuiGraphics());
                        this.getPlayerBar(player, scaled, event.getGuiGraphics());
                        this.getLockOn(player, scaled, event.getGuiGraphics());
                        this.getSkill(player, scaled, event.getGuiGraphics());
                    }
                } else if (player.m_5842_()) {
                    // empty if block
                }
            }
            this.getSoulFire(player, scaled, event.getGuiGraphics());
        }
    }

    private void getSoulFire(LocalPlayer player, Window scaled, GuiGraphics graphics) {
        int screenHeight = scaled.m_85446_();
        int posY = screenHeight - 74;
        int move = player.f_19797_ % 20;
        player.getCapability(TDEPlayerCapabilities.PLAYER_ABILITIES).ifPresent(abilities -> {
            PlayerAttribute soulfire = abilities.get(AbilityType.SOULFIRE);
            if (soulfire != null) {
                int Ymove = 0;
                float fireMax = soulfire.getCurrentMax();
                float fireValue = soulfire.get();
                float n = fireValue / fireMax;
                Ymove = (double)n >= 0.66 ? 0 : ((double)n <= 0.33 ? 2 : 1);
                graphics.m_280163_(TDEHudID.NUMBER, 74, posY + 48, (float)((int)(fireValue * 8.0f)), 0.0f, 8, 19, 80, 19);
                graphics.m_280163_(TDEHudID.SOUL_FIRE, 10, posY, (float)(move * 64), (float)(Ymove * 64), 64, 64, 1280, 256);
            }
        });
    }

    private void getLockOn(LocalPlayer player, Window scaled, GuiGraphics graphics) {
        TDELocalPlayerPatch tdeLocalPlayerPatch;
        int screenHeight = scaled.m_85446_();
        int screenWidth = scaled.m_85445_();
        LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
        if (localPlayerPatch instanceof TDELocalPlayerPatch && (tdeLocalPlayerPatch = (TDELocalPlayerPatch)localPlayerPatch).isLockon()) {
            EnemyEntity enemyEntity;
            LivingEntity livingEntity = tdeLocalPlayerPatch.getTarget();
            ResourceLocation lockOnTexture = livingEntity instanceof EnemyEntity && (enemyEntity = (EnemyEntity)livingEntity).isKnockdown() ? TDEHudID.LOCK_ON_2 : TDEHudID.LOCK_ON_1;
            int centerX = (screenWidth - 15) / 2;
            int centerY = (screenHeight - 15) / 2;
            graphics.m_280163_(lockOnTexture, centerX, centerY, 0.0f, 0.0f, 15, 15, 15, 15);
        }
    }

    private void getPlayerBar(LocalPlayer player, Window scaled, GuiGraphics graphics) {
        if (this.renderhealth > player.m_21223_()) {
            this.renderhealth -= 0.05f;
            if (this.renderhealth < player.m_21223_()) {
                this.renderhealth = player.m_21223_();
            }
        } else if (this.renderhealth < player.m_21223_()) {
            this.renderhealth += 0.05f;
            if (this.renderhealth > player.m_21223_()) {
                this.renderhealth = player.m_21223_();
            }
        }
        int screenHeight = scaled.m_85446_();
        int yPos = screenHeight - 60;
        TDEUIUtils.drawDoubleTDEGrowBar(this.renderhealth, player.m_21223_(), player.m_21233_(), 100.0f, yPos, TDEHudID.BAR_LONG, TDEHudID.BAR_HEALTH, TDEHudID.BAR_HEALTH_B, graphics, 256, 10, 254, 10);
        float energy = TDEAbilityUtils.getAbility(AbilityType.ENERGY, (Player)player);
        float energyMax = TDEAbilityUtils.getAbilityMax(AbilityType.ENERGY, (Player)player);
        float mana = TDEAbilityUtils.getAbility(AbilityType.MANA, (Player)player);
        float manaMax = TDEAbilityUtils.getAbilityMax(AbilityType.MANA, (Player)player);
        if (this.renderenergy > energy) {
            this.renderenergy -= 1.0f;
            if (this.renderenergy < energy) {
                this.renderenergy = energy;
            }
        } else if (this.renderenergy < energy) {
            this.renderenergy += 1.0f;
            if (this.renderenergy > energy) {
                this.renderenergy = energy;
            }
        }
        TDEUIUtils.drawDoubleTDEGrowBar(this.renderenergy, energy, energyMax, 300.0f, yPos - 4, TDEHudID.BAR_SHORT, TDEHudID.BAR_ENERGY, TDEHudID.BAR_ENERGY_B, graphics, 128, 5, 126, 5);
        if (this.rendermana > mana) {
            this.rendermana -= 0.05f;
            if (this.rendermana < mana) {
                this.rendermana = mana;
            }
        } else if (this.rendermana < mana) {
            this.rendermana += 0.05f;
            if (this.rendermana > mana) {
                this.rendermana = mana;
            }
        }
        TDEUIUtils.drawDoubleTDEGrowBar(this.rendermana, mana, manaMax, 300.0f, yPos + 9, TDEHudID.BAR_SHORT, TDEHudID.BAR_MANA, TDEHudID.BAR_MANA_B, graphics, 128, 5, 126, 5);
    }

    private void learnSkill(LocalPlayer player, Window scaled, GuiGraphics graphics) {
        if (!this.isLearningSkill || this.learnSkillTimer < 0) {
            return;
        }
        ++this.learnSkillTimer;
        if (this.learnSkillTimer > 500) {
            this.isLearningSkill = false;
            return;
        }
        float alpha = this.learnSkillTimer < 60 ? (float)this.learnSkillTimer / 60.0f : (this.learnSkillTimer > 440 ? (float)(500 - this.learnSkillTimer) / 60.0f : 1.0f);
        int screenWidth = scaled.m_85445_();
        int screenHeight = scaled.m_85446_();
        int centerX = screenWidth / 2;
        int posY = (screenHeight - 50) / 2;
        LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
        Skill skill = this.learningSkill;
        if (skill instanceof SkillInfo) {
            SkillInfo skillInfo = (SkillInfo)skill;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 500.0f);
            graphics.m_280246_(1.0f, 1.0f, 1.0f, alpha);
            int skillX = centerX - 25;
            this.renderScaledTexture(graphics, TDEHudID.SKILL_DOWN, skillX, posY, 50, 50);
            ResourceLocation icon = new ResourceLocation(skillInfo.getIcon());
            this.renderScaledTexture(graphics, icon, skillX + 1, posY + 1, 48, 48);
            this.renderScaledTexture(graphics, TDEHudID.SKILL_UP, skillX, posY, 50, 50);
            int textColor = (int)(alpha * 255.0f) << 24 | 0xFFFFFF;
            String skillName = Component.m_237115_((String)skill.getTranslationKey()).getString();
            int textWidth = Minecraft.m_91087_().f_91062_.m_92895_(skillName);
            graphics.m_280488_(Minecraft.m_91087_().f_91062_, skillName, centerX - textWidth / 2, posY - 10, textColor);
            String skillDesc = skillInfo.getMoreText();
            textWidth = Minecraft.m_91087_().f_91062_.m_92895_(skillDesc);
            graphics.m_280488_(Minecraft.m_91087_().f_91062_, skillDesc, centerX - textWidth / 2, posY + 50, textColor);
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            graphics.m_280168_().m_85849_();
        }
    }

    private void getSkill(LocalPlayer player, Window scaled, GuiGraphics graphics) {
        int screenWidth = scaled.m_85445_();
        int screenHeight = scaled.m_85446_();
        int posY = screenHeight - 46;
        int centerX = (screenWidth - 24) / 2 - 60;
        LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
        for (TDESkillSlots slot : List.of(TDESkillSlots.CYCLE_1, TDESkillSlots.CYCLE_2, TDESkillSlots.CYCLE_3, TDESkillSlots.CYCLE_4, TDESkillSlots.CYCLE_5)) {
            if (localPlayerPatch == null) continue;
            Skill skill = localPlayerPatch.getSkill((SkillSlot)slot).getSkill();
            int coolDown = 0;
            int maxCoolDown = 0;
            if (skill instanceof CycleSkill) {
                CycleSkill cycleSkill = (CycleSkill)skill;
                coolDown = cycleSkill.getCoolDown((PlayerPatch<?>)localPlayerPatch);
                maxCoolDown = cycleSkill.getMaxCoolDown();
            }
            if (!(skill instanceof SkillInfo)) continue;
            SkillInfo skillInfo = (SkillInfo)skill;
            ResourceLocation icon = new ResourceLocation(skillInfo.getIcon());
            boolean isActive = (float)slot.getCycle() == TDEAbilityUtils.getAbility(AbilityType.CYCLE, (Player)player);
            this.renderScaledTexture(graphics, TDEHudID.SKILL_DOWN, centerX, posY, 24, 24);
            this.renderScaledTexture(graphics, icon, centerX + 2, posY + 2, 20, 20);
            if (coolDown > 0 && maxCoolDown > 0) {
                float progress = (float)coolDown / (float)maxCoolDown;
                this.renderCooldownOverlay(graphics, centerX + 2, posY + 2, 20, 20, progress);
                String timeText = String.format("%.1f", Float.valueOf((float)coolDown / 20.0f));
                this.renderCenteredText(graphics, timeText, centerX + 12, posY + 12);
            }
            ResourceLocation border = isActive ? TDEHudID.SKILL_UP_NOW : TDEHudID.SKILL_UP;
            this.renderScaledTexture(graphics, border, centerX, posY, 24, 24);
            centerX += 30;
        }
    }

    private void renderCooldownOverlay(GuiGraphics graphics, int x, int y, int width, int height, float progress) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        int overlayHeight = (int)((float)height * progress);
        int overlayY = y + height - overlayHeight;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        float r = 0.1254902f;
        float g = 0.1254902f;
        float b = 0.1254902f;
        float a = 0.5019608f;
        buffer.m_252986_(matrix, (float)x, (float)overlayY, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, (float)x, (float)(y + height), 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, (float)(x + width), (float)(y + height), 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, (float)(x + width), (float)overlayY, 0.0f).m_85950_(r, g, b, a).m_5752_();
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }

    private void renderCenteredText(GuiGraphics graphics, String text, int x, int y) {
        Font font = Minecraft.m_91087_().f_91062_;
        int textWidth = font.m_92895_(text);
        Objects.requireNonNull(font);
        int textHeight = 9;
        int textX = x - textWidth / 2;
        int textY = y - textHeight / 2;
        graphics.m_280488_(font, text, textX, textY, 0xFFFFFF);
    }

    private void renderScaledTexture(GuiGraphics graphics, ResourceLocation texture, int x, int y, int width, int height) {
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        buffer.m_252986_(matrix, (float)x, (float)y, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, (float)x, (float)(y + height), 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, (float)(x + width), (float)(y + height), 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, (float)(x + width), (float)y, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }

    private void getPlayerAirBar(LocalPlayer player, Window scaled, GuiGraphics graphics) {
        int screenWidth = scaled.m_85445_();
        int screenHeight = scaled.m_85446_();
        int posY = screenHeight - 45;
        float Multiplier = 1.0f - (float)player.m_20146_() / 300.0f;
        int cut = (int)(123.0f * Multiplier);
        graphics.m_280163_(TDEHudID.BAR_LONG, (screenWidth - 256) / 2, posY, 0.0f, 0.0f, 256, 16, 256, 16);
        graphics.m_280163_(TDEHudID.BAR_AIR, (screenWidth - 246) / 2 + cut, posY, (float)cut, (float)(player.f_19797_ % 20 * 16), 246 - cut * 2, 16, 246, 320);
    }

    private void renderKeyHints(Window scaled, GuiGraphics graphics) {
        Font font = this.minecraft.f_91062_;
        int maxWidth = 0;
        for (Pair<String, KeyMapping> hint : KEY_HINTS) {
            String functionName = Component.m_237115_((String)((String)hint.getFirst())).getString();
            int width = font.m_92895_(functionName + ": ") + font.m_92895_(this.getKeyName((KeyMapping)hint.getSecond()));
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        int screenWidth = scaled.m_85445_();
        int screenHeight = scaled.m_85446_();
        int startX = screenWidth - maxWidth - 10;
        int startY = screenHeight - KEY_HINTS.size() * 12 - 30;
        for (int i = 0; i < KEY_HINTS.size(); ++i) {
            Pair<String, KeyMapping> hint = KEY_HINTS.get(i);
            int yPos = startY + i * 12;
            String functionName = Component.m_237115_((String)((String)hint.getFirst())).getString();
            graphics.m_280488_(font, functionName + ": ", startX, yPos, 0xAAAAAA);
            int keyX = startX + font.m_92895_(functionName + ": ");
            graphics.m_280488_(font, this.getKeyName((KeyMapping)hint.getSecond()), keyX, yPos, 16766720);
        }
    }

    private String getKeyName(KeyMapping keyMapping) {
        return keyMapping.m_90863_().getString();
    }

    private void renderSoulCount(LocalPlayer player, Window scaled, GuiGraphics graphics) {
        float currentSoul = TDEAbilityUtils.getAbility(AbilityType.SOUL, (Player)player);
        if (this.lastSoulValue < 0.0f) {
            this.lastSoulValue = currentSoul;
        }
        if (currentSoul != this.lastSoulValue) {
            this.soulChangeValue = currentSoul - this.lastSoulValue;
            this.soulChangeTimer = 80;
            this.lastSoulValue = currentSoul;
        }
        int screenWidth = scaled.m_85445_();
        int x = screenWidth - 120;
        int y = 20;
        int iconX = x;
        int iconY = y;
        graphics.m_280163_(TDEHudID.SOUL, iconX, iconY, 0.0f, 0.0f, 16, 16, 16, 16);
        Font font = this.minecraft.f_91062_;
        String soulText = String.format("%.0f", Float.valueOf(currentSoul));
        int textX = iconX + 16 + 1;
        Objects.requireNonNull(font);
        int textY = y + (16 - 9) / 2;
        graphics.m_280488_(font, soulText, textX, textY, 0xFFFFFF);
        if (this.soulChangeTimer > 0) {
            float progress = (float)this.soulChangeTimer / 80.0f;
            int alpha = (int)(255.0f * progress);
            int offsetY = (int)(20.0f * (1.0f - progress));
            int color = this.soulChangeValue > 0.0f ? -16711936 : -65536;
            color = alpha << 24 | color & 0xFFFFFF;
            String changeText = String.format("%s%.0f", this.soulChangeValue > 0.0f ? "+" : "", Float.valueOf(this.soulChangeValue));
            int changeX = textX + font.m_92895_(soulText) + 4;
            int changeY = textY - offsetY;
            graphics.m_280488_(font, changeText, changeX, changeY, color);
            --this.soulChangeTimer;
        }
    }

    static {
        KEY_HINTS = Arrays.asList(new Pair((Object)"key.tde.interaction", (Object)TDEKeyMappings.INTERACTION), new Pair((Object)"key.tde.basic_attack", (Object)TDEKeyMappings.BASIC_ATTACK), new Pair((Object)"key.tde.charge_attack", (Object)TDEKeyMappings.CHARGED_ATTACK), new Pair((Object)"key.tde.guard", (Object)TDEKeyMappings.GUARD), new Pair((Object)"key.tde.dodge", (Object)EpicFightKeyMappings.DODGE), new Pair((Object)"key.tde.soul_fire", (Object)TDEKeyMappings.SOULFIRE_SKILL), new Pair((Object)"key.tde.lockon", (Object)TDEKeyMappings.LOCK_ON), new Pair((Object)"key.tde.lockon_change", (Object)TDEKeyMappings.LOCK_ON_CHANGE), new Pair((Object)"key.tde.skill", (Object)TDEKeyMappings.SKILL));
    }
}

