/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.client.gui.npc.dialogue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;

public class DialogueTree {
    private final Entity boundEntity;
    private final String entityId;
    private DialogueNode rootNode;

    public DialogueTree(Entity boundEntity) {
        this.boundEntity = boundEntity;
        ResourceLocation registryName = EntityType.m_20613_((EntityType)boundEntity.m_6095_());
        this.entityId = registryName.toString().replace(':', '.');
    }

    public void setRootNode(DialogueNode rootNode) {
        this.rootNode = rootNode;
        this.registerNodeAndChildren(rootNode);
    }

    private void registerNodeAndChildren(DialogueNode node) {
        node.setTree(this);
        for (DialogueNode child : node.getChildren()) {
            this.registerNodeAndChildren(child);
        }
    }

    public DialogueNode getRootNode() {
        return this.rootNode;
    }

    public Entity getBoundEntity() {
        return this.boundEntity;
    }

    public static abstract class DialogueNode {
        private final String id;
        private final List<DialogueNode> children = new ArrayList<DialogueNode>();
        private final List<Predicate<Player>> conditions = new ArrayList<Predicate<Player>>();
        public DialogueTree tree;

        public DialogueNode(String id) {
            this.id = id;
        }

        void setTree(DialogueTree tree) {
            this.tree = tree;
        }

        public void addChild(DialogueNode child) {
            this.children.add(child);
        }

        public void addCondition(Predicate<Player> condition) {
            this.conditions.add(condition);
        }

        public List<DialogueNode> getChildren() {
            return Collections.unmodifiableList(this.children);
        }

        public List<DialogueNode> getAvailableChildren(Player player) {
            ArrayList<DialogueNode> available = new ArrayList<DialogueNode>();
            for (DialogueNode child : this.children) {
                if (!child.isAvailable(player)) continue;
                available.add(child);
            }
            return available;
        }

        public boolean isAvailable(Player player) {
            for (Predicate<Player> condition : this.conditions) {
                if (condition.test(player)) continue;
                return false;
            }
            return true;
        }

        protected String getLangKey() {
            return "entity." + this.tree.entityId + ".dialogue." + this.id;
        }

        protected String getLocalizedText() {
            String key = this.getLangKey();
            return key;
        }

        public abstract String getOptionText(Player var1);

        public abstract String getResponseText(Player var1);

        public abstract void onSelected(Player var1);

        public String getId() {
            return this.id;
        }
    }

    public static class DialogueSystem {
        private static final Map<Entity, DialogueTree> entityTrees = new WeakHashMap<Entity, DialogueTree>();

        public static void registerEntityTree(Entity entity, DialogueTree tree) {
            entityTrees.put(entity, tree);
        }

        public static DialogueTree getTreeForEntity(Entity entity) {
            return entityTrees.get(entity);
        }
    }

    public static class Option {
        private final String optionText;
        private final String responseText;
        private final DialogueNode targetNode;

        public Option(String optionText, String responseText, DialogueNode targetNode) {
            this.optionText = optionText;
            this.responseText = responseText;
            this.targetNode = targetNode;
        }

        public String getOptionText() {
            return this.optionText;
        }

        public String getResponseText() {
            return this.responseText;
        }

        public DialogueNode getTargetNode() {
            return this.targetNode;
        }
    }

    public static class OptionNode
    extends DialogueNode {
        public OptionNode(String id) {
            super(id);
        }

        @Override
        public String getOptionText(Player player) {
            return this.getLocalizedText();
        }

        @Override
        public String getResponseText(Player player) {
            return null;
        }

        @Override
        public void onSelected(Player player) {
        }

        public List<Option> getOptions(Player player) {
            ArrayList<Option> options = new ArrayList<Option>();
            for (DialogueNode child : this.getAvailableChildren(player)) {
                options.add(new Option(child.getOptionText(player), child.getResponseText(player), child));
            }
            return options;
        }
    }

    public static class TextNode
    extends DialogueNode {
        private final String responseKey;

        public TextNode(String id) {
            this(id, id + ".response");
        }

        public TextNode(String id, String responseKey) {
            super(id);
            this.responseKey = responseKey;
        }

        @Override
        public String getOptionText(Player player) {
            return this.getLocalizedText();
        }

        @Override
        public String getResponseText(Player player) {
            String key = "entity." + this.tree.entityId + ".dialogue." + this.responseKey;
            return key;
        }

        @Override
        public void onSelected(Player player) {
        }
    }
}

