/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.client.gui.campfire;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.client.gui.UiResource;
import com.merlin204.tde.epicfight.gameassets.skill.SkillInfo;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import com.merlin204.tde.item.TDEArmorItems;
import com.merlin204.tde.item.TDEWeaponitems;
import com.merlin204.tde.network.NetworkHandler;
import com.merlin204.tde.network.client.CPGiveItemPacket;
import com.merlin204.tde.util.TDEAbilityUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import yesman.epicfight.api.data.reloader.SkillManager;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPChangeSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.skill.CapabilitySkill;

public class FirstFireUI {
    private static Skill chosenSkill;
    private static WidgetGroup root;
    private static DraggableScrollableWidgetGroup skillList;
    private static WidgetGroup skillInfo;
    private static WidgetGroup abilityInfo;
    private static final Map<String, List<ItemStack>> INITIAL_ITEMS;

    public static WidgetGroup createUI() {
        root = new WidgetGroup();
        root.setSize(0, 0);
        root.setSelfPosition(0, 0);
        WidgetGroup back = new WidgetGroup();
        back.setBackground(new IGuiTexture[]{UiResource.BACKGROUND_1});
        back.setSize(330, 210);
        back.setSelfPosition(-165, -105);
        skillList = new DraggableScrollableWidgetGroup();
        skillList.setSize(110, 200);
        skillList.setBackground((IGuiTexture)UiResource.BACKGROUND_2);
        skillList.setSelfPosition(-160, -100);
        skillInfo = new WidgetGroup();
        skillInfo.setSize(200, 200);
        skillInfo.setBackground(new IGuiTexture[]{UiResource.BACKGROUND_2});
        skillInfo.setSelfPosition(-40, -100);
        abilityInfo = new WidgetGroup();
        abilityInfo.setSize(180, 74);
        abilityInfo.setSelfPosition(10, 95);
        abilityInfo.setBackground(new IGuiTexture[]{UiResource.BACKGROUND_1});
        root.addWidget((Widget)back);
        root.addWidget((Widget)skillList);
        root.addWidget((Widget)skillInfo);
        FirstFireUI.populateSkillList();
        FirstFireUI.updateSkillInfo();
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void populateSkillList() {
        DraggableScrollableWidgetGroup draggableScrollableWidgetGroup = skillList;
        synchronized (draggableScrollableWidgetGroup) {
            Iterator iterator = FirstFireUI.skillList.widgets.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
            ArrayList<Skill> initialSkills = new ArrayList<Skill>();
            for (String skillId : INITIAL_ITEMS.keySet()) {
                initialSkills.add(SkillManager.getSkill((String)skillId));
            }
            int number = 0;
            for (Skill skill : initialSkills) {
                FirstFireUI.addSkillOption(number, skill);
                ++number;
            }
            if (!initialSkills.isEmpty() && chosenSkill == null) {
                chosenSkill = (Skill)initialSkills.iterator().next();
                FirstFireUI.updateSkillInfo();
            }
        }
    }

    private static void addSkillOption(int index, Skill skill) {
        int yOffset = 32;
        int yPos = index * yOffset;
        ButtonWidget button = new ButtonWidget();
        button.setSize(100, 30);
        button.setSelfPosition(5, yPos + 5);
        if (skill == chosenSkill) {
            button.setBackground(new IGuiTexture[]{UiResource.BUTTON_1_DOWN});
        } else {
            button.setBackground(new IGuiTexture[]{UiResource.BUTTON_1});
        }
        button.setOnPressCallback(clickData -> {
            if (!clickData.isRemote) {
                chosenSkill = skill;
                Minecraft.m_91087_().m_6937_(() -> {
                    FirstFireUI.updateSkillInfo();
                    FirstFireUI.updateSkillListHighlights();
                });
            }
        });
        ImageWidget icon = new ImageWidget();
        icon.setSize(24, 24);
        icon.setSelfPosition(8, yPos + 8);
        if (skill instanceof SkillInfo) {
            SkillInfo skillInfo = (SkillInfo)skill;
            icon.setBackground(new IGuiTexture[]{UiResource.SLOT_1_BACK, new ResourceTexture(skillInfo.getIcon()), UiResource.SLOT_1_UP});
        }
        ImageWidget name = new ImageWidget();
        name.setSize(70, 20);
        name.setSelfPosition(35, yPos + 10);
        TextTexture nameText = new TextTexture();
        nameText.setWidth(65).setType(TextTexture.TextType.LEFT).updateText(skill.getDisplayName().getString());
        name.setBackground(new IGuiTexture[]{nameText});
        skillList.addWidget((Widget)button);
        skillList.addWidget((Widget)icon);
        skillList.addWidget((Widget)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateSkillInfo() {
        WidgetGroup widgetGroup = skillInfo;
        synchronized (widgetGroup) {
            Skill skill;
            Iterator iterator = FirstFireUI.skillInfo.widgets.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
            if (chosenSkill == null || !((skill = chosenSkill) instanceof SkillInfo)) {
                return;
            }
            SkillInfo skillInfoObj = (SkillInfo)skill;
            ImageWidget icon = new ImageWidget();
            icon.setSize(48, 48);
            icon.setSelfPosition(76, 10);
            icon.setBackground(new IGuiTexture[]{UiResource.SLOT_1_BACK, new ResourceTexture(skillInfoObj.getIcon()), UiResource.SLOT_1_UP});
            ImageWidget desc = new ImageWidget();
            desc.setSize(180, 50);
            desc.setSelfPosition(10, 50);
            TextTexture descText = new TextTexture();
            descText.setWidth(180).setType(TextTexture.TextType.LEFT).updateText(skillInfoObj.getMoreText());
            desc.setBackground(new IGuiTexture[]{descText});
            abilityInfo.clearAllWidgets();
            FirstFireUI.addAbilityNeed(abilityInfo, 0, 0, AbilityType.VITALITY, "ability.tde.Vitality");
            FirstFireUI.addAbilityNeed(abilityInfo, 0, 1, AbilityType.STRENGTH, "ability.tde.strength");
            FirstFireUI.addAbilityNeed(abilityInfo, 0, 2, AbilityType.DEXTERITY, "ability.tde.dexterity");
            FirstFireUI.addAbilityNeed(abilityInfo, 1, 0, AbilityType.INTELLIGENCE, "ability.tde.intelligence");
            FirstFireUI.addAbilityNeed(abilityInfo, 1, 1, AbilityType.STAMINA, "ability.tde.stamina");
            FirstFireUI.addAbilityNeed(abilityInfo, 1, 2, AbilityType.ARCANE, "ability.tde.arcane");
            ButtonWidget learnButton = new ButtonWidget();
            learnButton.setSize(100, 20);
            learnButton.setSelfPosition(50, 170);
            TextTexture learnText = new TextTexture(Component.m_237115_((String)"gui.tde.firstfire.learn").getString()).setType(TextTexture.TextType.NORMAL);
            learnButton.setButtonTexture(new IGuiTexture[]{UiResource.BUTTON_1, learnText});
            learnButton.setClickedTexture(new IGuiTexture[]{UiResource.BUTTON_1_DOWN, learnText});
            learnButton.setOnPressCallback(clickData -> {
                if (!clickData.isRemote) {
                    LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
                    CapabilitySkill skills = localPlayerPatch.getSkillCapability();
                    String skillId = chosenSkill.toString();
                    skills.skillContainers[TDESkillSlots.SECT.universalOrdinal()].setSkill(chosenSkill);
                    skills.addLearnedSkill(chosenSkill);
                    EpicFightNetworkManager.sendToServer((Object)new CPChangeSkill(TDESkillSlots.SECT.universalOrdinal(), -1, chosenSkill.toString(), !((LocalPlayer)localPlayerPatch.getOriginal()).m_7500_()));
                    for (ItemStack itemStack : INITIAL_ITEMS.get(skillId)) {
                        NetworkHandler.sendToServer(new CPGiveItemPacket(itemStack));
                    }
                    for (AbilityType type : List.of(AbilityType.STRENGTH, AbilityType.VITALITY, AbilityType.DEXTERITY, AbilityType.INTELLIGENCE, AbilityType.STAMINA, AbilityType.ARCANE)) {
                        Skill patt9641$temp = chosenSkill;
                        if (!(patt9641$temp instanceof SkillInfo)) continue;
                        SkillInfo skillInfo = (SkillInfo)patt9641$temp;
                        float requirement = skillInfo.getAbilityRequirement(type);
                        TDEAbilityUtils.setAbility(type, (Player)localPlayerPatch.getOriginal(), requirement + 4.0f);
                    }
                    Minecraft mc = Minecraft.m_91087_();
                    if (mc.f_91080_ != null) {
                        mc.f_91067_.m_91602_();
                        mc.m_91152_(null);
                        mc.f_91067_.m_91601_();
                        mc.execute(() -> {
                            if (mc.f_91080_ != null) {
                                mc.m_91152_(null);
                            }
                            if (mc.f_91067_.m_91600_()) {
                                mc.f_91067_.m_91602_();
                            }
                        });
                    }
                }
            });
            skillInfo.addWidget((Widget)icon);
            skillInfo.addWidget((Widget)desc);
            skillInfo.addWidget((Widget)abilityInfo);
            skillInfo.addWidget((Widget)learnButton);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateSkillListHighlights() {
        DraggableScrollableWidgetGroup draggableScrollableWidgetGroup = skillList;
        synchronized (draggableScrollableWidgetGroup) {
            ArrayList childrenSnapshot = new ArrayList(FirstFireUI.skillList.widgets);
            for (int i = 0; i < childrenSnapshot.size(); i += 3) {
                Widget widget = (Widget)childrenSnapshot.get(i);
                if (!(widget instanceof ButtonWidget)) continue;
                ButtonWidget button = (ButtonWidget)widget;
                Skill skill = FirstFireUI.getSkillAtIndex(i / 3);
                if (skill == chosenSkill) {
                    button.setBackground(new IGuiTexture[]{UiResource.BUTTON_1_DOWN});
                    continue;
                }
                button.setBackground(new IGuiTexture[]{UiResource.BUTTON_1});
            }
        }
    }

    private static Skill getSkillAtIndex(int index) {
        ArrayList<Skill> skills = new ArrayList<Skill>();
        for (String skillId : INITIAL_ITEMS.keySet()) {
            skills.add(SkillManager.getSkill((String)skillId));
        }
        if (index >= 0 && index < skills.size()) {
            return skills.toArray(new Skill[0])[index];
        }
        return null;
    }

    private static void addAbilityNeed(WidgetGroup group, int col, int row, AbilityType type, String key) {
        int xOffset = 80;
        int yOffset = 22;
        int xPos = 8 + col * xOffset;
        int yPos = 8 + row * yOffset;
        Skill skill = chosenSkill;
        if (!(skill instanceof SkillInfo)) {
            return;
        }
        SkillInfo skillInfo = (SkillInfo)skill;
        ImageWidget name = new ImageWidget();
        name.setSize(50, 16);
        name.setSelfPosition(xPos, yPos);
        TextTexture nameText = new TextTexture();
        nameText.setWidth(50).setType(TextTexture.TextType.LEFT).updateText(Component.m_237115_((String)key).getString());
        name.setBackground(new IGuiTexture[]{nameText});
        ImageWidget value = new ImageWidget();
        value.setSize(20, 16);
        value.setSelfPosition(xPos + 45, yPos);
        TextTexture valueText = new TextTexture();
        valueText.setWidth(20).setType(TextTexture.TextType.RIGHT).updateText(String.valueOf((int)skillInfo.getAbilityRequirement(type)));
        value.setBackground(new IGuiTexture[]{valueText});
        group.addWidget((Widget)name);
        group.addWidget((Widget)value);
    }

    static {
        INITIAL_ITEMS = Map.of("tde:se1_1", List.of(new ItemStack((ItemLike)TDEWeaponitems.W1_2.get()), new ItemStack((ItemLike)TDEArmorItems.A1_2_2.get()), new ItemStack((ItemLike)TDEArmorItems.A1_2_3.get()), new ItemStack((ItemLike)TDEArmorItems.A1_2_4.get())), "tde:se1_2", List.of(new ItemStack((ItemLike)TDEWeaponitems.W1_1.get()), new ItemStack((ItemLike)TDEWeaponitems.W1_1.get()), new ItemStack((ItemLike)TDEArmorItems.A1_2_2.get()), new ItemStack((ItemLike)TDEArmorItems.A1_2_3.get()), new ItemStack((ItemLike)TDEArmorItems.A1_2_4.get())), "tde:se1_3", List.of(new ItemStack((ItemLike)TDEWeaponitems.W1_5.get()), new ItemStack((ItemLike)TDEWeaponitems.W1_6.get()), new ItemStack((ItemLike)TDEArmorItems.A1_2_2.get()), new ItemStack((ItemLike)TDEArmorItems.A1_2_3.get()), new ItemStack((ItemLike)TDEArmorItems.A1_2_4.get())));
    }
}

