/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.client.gui.campfire;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.merlin204.tde.client.gui.UiResource;
import com.merlin204.tde.client.gui.campfire.FirstFireUI;
import com.merlin204.tde.client.gui.campfire.levelup.LevelUpUI;
import com.merlin204.tde.client.gui.campfire.skill.SkillUI;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.skill.SkillSlot;

public class CampfireUI {
    public static WidgetGroup createUI() {
        LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
        if (localPlayerPatch.getSkill((SkillSlot)TDESkillSlots.SECT).getSkill() == null) {
            return FirstFireUI.createUI();
        }
        WidgetGroup root = new WidgetGroup();
        root.setSelfPosition(0, 0);
        root.setSize(0, 0);
        WidgetGroup mainScreen = new WidgetGroup();
        WidgetGroup levelUp = new WidgetGroup();
        WidgetGroup skill = new WidgetGroup();
        SkillUI.setSkillUI(skill);
        LevelUpUI.setLevelUp(levelUp);
        ButtonWidget back = new ButtonWidget();
        CampfireUI.setMainScreen(mainScreen, back, levelUp, skill);
        root.addWidget((Widget)levelUp);
        root.addWidget((Widget)skill);
        root.addWidget((Widget)mainScreen);
        root.addWidget((Widget)back);
        return root;
    }

    private static void setMainScreen(WidgetGroup mainScreen, ButtonWidget back, WidgetGroup levelUp, WidgetGroup skill) {
        LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
        Player player = (Player)localPlayerPatch.getOriginal();
        mainScreen.setSize(0, 0);
        mainScreen.setSelfPosition(0, 0);
        ButtonWidget fireback = new ButtonWidget();
        fireback.setActive(false);
        fireback.setSize(60, 60);
        fireback.setSelfPosition(-30, -30);
        ImageWidget aniFire = new ImageWidget();
        aniFire.setSelfPosition(-30, -30);
        aniFire.setSize(60, 60);
        aniFire.setImage(() -> {
            int i = player.f_19797_ % 20;
            return new ResourceTexture("tde:textures/gui/fire/soulfire/soulfire_" + i + ".png");
        });
        fireback.setButtonTexture(new IGuiTexture[]{UiResource.BACKGROUND_1});
        ButtonWidget button_1 = new ButtonWidget();
        button_1.appendHoverTooltips(new String[]{Component.m_237115_((String)"gui.tde.campfire.button_1.tip").getString()});
        ButtonWidget button_2 = new ButtonWidget();
        ButtonWidget button_3 = new ButtonWidget();
        ButtonWidget button_4 = new ButtonWidget();
        ButtonWidget button_5 = new ButtonWidget();
        ButtonWidget button_6 = new ButtonWidget();
        CampfireUI.setButtonHIDE(button_1, 50, 20, -100, -60, (Component)Component.m_237115_((String)"gui.tde.campfire.button_1"));
        CampfireUI.setButtonHIDE(button_2, 50, 20, -100, -10, (Component)Component.m_237115_((String)"gui.tde.campfire.button_2"));
        CampfireUI.setButtonHIDE(button_3, 50, 20, -100, 40, (Component)Component.m_237115_((String)"gui.tde.campfire.button_3"));
        CampfireUI.setButtonHIDE(button_4, 50, 20, 50, -60, (Component)Component.m_237115_((String)"gui.tde.campfire.button_4"));
        CampfireUI.setButtonHIDE(button_5, 50, 20, 50, -10, (Component)Component.m_237115_((String)"gui.tde.campfire.button_5"));
        CampfireUI.setButtonHIDE(button_6, 50, 20, 50, 40, (Component)Component.m_237115_((String)"gui.tde.campfire.button_6"));
        CampfireUI.setButtonHIDE(back, 50, 20, -25, 110, (Component)Component.m_237115_((String)"gui.tde.campfire.back"));
        button_1.setOnPressCallback(clickData -> {
            mainScreen.setActive(false).setVisible(false);
            levelUp.setActive(true).setVisible(true);
        });
        button_2.setOnPressCallback(clickData -> {
            mainScreen.setActive(false).setVisible(false);
            skill.setActive(true).setVisible(true);
        });
        back.setOnPressCallback(clickData -> {
            if (mainScreen.isActive()) {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91080_ != null) {
                    mc.f_91067_.m_91602_();
                    mc.m_91152_(null);
                    mc.f_91067_.m_91601_();
                    mc.execute(() -> {
                        if (mc.f_91080_ != null) {
                            mc.m_91152_(null);
                        }
                        if (mc.f_91067_.m_91600_()) {
                            mc.f_91067_.m_91602_();
                        }
                    });
                }
            } else {
                mainScreen.setActive(true).setVisible(true);
                skill.setActive(false).setVisible(false);
                levelUp.setActive(false).setVisible(false);
            }
        });
        mainScreen.addWidget((Widget)button_1);
        mainScreen.addWidget((Widget)button_2);
        mainScreen.addWidget((Widget)button_3);
        mainScreen.addWidget((Widget)button_4);
        mainScreen.addWidget((Widget)button_5);
        mainScreen.addWidget((Widget)button_6);
        mainScreen.addWidget((Widget)fireback);
        mainScreen.addWidget((Widget)aniFire);
    }

    private static void setButtonHIDE(ButtonWidget buttonWidget, int width, int height, int x, int y, Component component) {
        TextTexture textAbove = new TextTexture(component.getString()).setType(TextTexture.TextType.HIDE).setDropShadow(false);
        buttonWidget.setSize(width, height);
        buttonWidget.setSelfPosition(x, y);
        buttonWidget.setButtonTexture(new IGuiTexture[]{UiResource.BUTTON_1, textAbove});
        buttonWidget.setClickedTexture(new IGuiTexture[]{UiResource.BUTTON_1_DOWN, textAbove});
    }
}

