/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.client.gui;

import com.google.common.collect.Maps;
import com.merlin204.tde.client.hud.TDEHudID;
import com.merlin204.tde.entity.boss.BossEntity;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.enemy.EnemyPatch;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Matrix4f;
import yesman.epicfight.client.gui.HealthBar;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.effect.VisibleMobEffect;

@OnlyIn(value=Dist.CLIENT)
public class TDEHealthBar
extends HealthBar {
    public static final ResourceLocation BARS = TDEHudID.ENEMY_BAR;
    private final Map<LivingEntity, EntityAttributeTracker> trackingEntities = Maps.newHashMap();

    public void draw(LivingEntity entity, @Nullable LivingEntityPatch<?> entitypatch, LocalPlayerPatch playerpatch, PoseStack poseStack, MultiBufferSource buffers, float partialTicks) {
        Matrix4f modelViewMatrix = super.getModelViewMatrixAlignedToCamera(poseStack, entity, 0.0f, entity.m_20206_() + 0.25f, 0.0f, true, partialTicks);
        Collection activeEffects = entity.m_21220_();
        if (!(entitypatch instanceof EnemyPatch)) {
            return;
        }
        if (!activeEffects.isEmpty() && !entity.m_7306_(playerpatch.getOriginal())) {
            Iterator iter = activeEffects.iterator();
            int acives = activeEffects.size();
            int row = acives > 1 ? 1 : 0;
            int column = (acives - 1) / 2;
            float startX = -0.8f + -0.3f * (float)row;
            float startY = -0.15f + 0.15f * (float)column;
            block0: for (int i = 0; i <= column; ++i) {
                for (int j = 0; j <= row; ++j) {
                    ResourceLocation rl;
                    MobEffectInstance effectInstance = (MobEffectInstance)iter.next();
                    MobEffect effect = effectInstance.m_19544_();
                    if (effect instanceof VisibleMobEffect) {
                        VisibleMobEffect visibleMobEffect = (VisibleMobEffect)effect;
                        rl = visibleMobEffect.getIcon(effectInstance);
                    } else {
                        rl = ResourceLocation.fromNamespaceAndPath((String)ForgeRegistries.MOB_EFFECTS.getKey((Object)effect).m_135827_(), (String)("textures/mob_effect/" + ForgeRegistries.MOB_EFFECTS.getKey((Object)effect).m_135815_() + ".png"));
                    }
                    float x = startX + 0.3f * (float)j;
                    float y = startY + -0.3f * (float)i;
                    TDEHealthBar.drawUIAsLevelModel((Matrix4f)modelViewMatrix, (ResourceLocation)rl, (MultiBufferSource)buffers, (float)x, (float)y, (float)(x + 0.3f), (float)(y + 0.3f), (int)0, (int)0, (int)256, (int)256, (int)256);
                    if (!iter.hasNext()) continue block0;
                }
            }
        }
        EntityAttributeTracker attributeTracker = this.trackingEntities.get(entity);
        ResourceLocation healthBarTexture = BARS;
        int textureIndex = 0;
        int damageColor = -65536;
        float healthBarHeight = 0.048828125f;
        float innerHealthBarHeight = 0.029296875f;
        float maxHealth = entity.m_21233_();
        float partialHealth = attributeTracker.healthState.getAnimatedValue(entity.f_19797_, partialTicks);
        float partialEnergy = attributeTracker.energyState.getAnimatedValue(entity.f_19797_, partialTicks);
        if (entitypatch instanceof EnemyPatch) {
            EnemyPatch enemyPatch = (EnemyPatch)entitypatch;
            textureIndex = 0;
            int texV = textureIndex * 16;
            TDEHealthBar.drawUIAsLevelModel((Matrix4f)modelViewMatrix, (ResourceLocation)BARS, (MultiBufferSource)buffers, (float)-0.475f, (float)-0.1f, (float)0.475f, (float)-0.05f, (float)0.0f, (float)0.25f, (float)1.0f, (float)0.3125f);
            float energyRatio = Mth.m_14036_((float)(((EnemyEntity)enemyPatch.getOriginal()).getEnergy() / ((EnemyEntity)enemyPatch.getOriginal()).getMaxEnergy()), (float)0.0f, (float)1.0f);
            float filledEnergyEnd = Math.max(-0.5f + energyRatio, -0.46875f);
            if (((EnemyEntity)enemyPatch.getOriginal()).canEnergyRecover()) {
                TDEHealthBar.drawUIAsLevelModel((Matrix4f)modelViewMatrix, (ResourceLocation)BARS, (MultiBufferSource)buffers, (float)-0.475f, (float)-0.1f, (float)(filledEnergyEnd * 0.95f), (float)-0.05f, (float)0.0f, (float)0.140625f, (float)energyRatio, (float)0.1875f);
            } else {
                TDEHealthBar.drawUIAsLevelModel((Matrix4f)modelViewMatrix, (ResourceLocation)BARS, (MultiBufferSource)buffers, (float)-0.475f, (float)-0.1f, (float)(filledEnergyEnd * 0.95f), (float)-0.05f, (float)0.0f, (float)0.1875f, (float)energyRatio, (float)0.25f);
            }
        }
        TDEHealthBar.drawUIAsLevelModel((Matrix4f)modelViewMatrix, (ResourceLocation)BARS, (MultiBufferSource)buffers, (float)-0.5f, (float)-0.048828125f, (float)0.5f, (float)0.048828125f, (float)0.0f, (float)0.0625f, (float)1.0f, (float)0.125f);
        float healthRatio = Mth.m_14036_((float)(entity.m_21223_() / maxHealth), (float)0.0f, (float)1.0f);
        float filledHealthEnd = Math.max(-0.5f + healthRatio, -0.46875f);
        TDEHealthBar.drawUIAsLevelModel((Matrix4f)modelViewMatrix, (ResourceLocation)BARS, (MultiBufferSource)buffers, (float)-0.5f, (float)-0.048828125f, (float)filledHealthEnd, (float)0.048828125f, (float)0.0f, (float)0.0f, (float)healthRatio, (float)0.0625f);
    }

    public boolean shouldDraw(LivingEntity entity, @Nullable LivingEntityPatch<?> entitypatch, LocalPlayerPatch playerpatch, float partialTicks) {
        HealthBar.HealthBarVisibility healthBarVisibility = ClientConfig.healthBarVisibility;
        Minecraft mc = Minecraft.m_91087_();
        if (entity instanceof Player) {
            return false;
        }
        if (entity instanceof BossEntity) {
            return false;
        }
        if (entity.m_6095_().m_204039_(Tags.EntityTypes.BOSSES)) {
            return false;
        }
        EntityAttributeTracker healthTracker = this.trackingEntities.computeIfAbsent(entity, key -> new EntityAttributeTracker((LivingEntity)key, entitypatch));
        healthTracker.checkChange(partialTicks);
        healthTracker.setKeepUp(true);
        if (entity.m_20177_((Player)playerpatch.getOriginal()) || entity == ((LocalPlayer)playerpatch.getOriginal()).m_20202_()) {
            return false;
        }
        if (entity.m_20280_(mc.m_91288_()) >= 400.0) {
            return false;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player == playerpatch.getOriginal() && playerpatch.getMaxStunShield() <= 0.0f) {
                return false;
            }
            if (player.m_7500_() || player.m_5833_()) {
                return false;
            }
        }
        boolean showTarget = false;
        if (healthBarVisibility == HealthBar.HealthBarVisibility.TARGET) {
            return playerpatch.getTarget() == entity;
        }
        if (healthBarVisibility == HealthBar.HealthBarVisibility.TARGET_AND_HURT) {
            showTarget = playerpatch.getTarget() == entity;
        }
        return (!entity.m_21220_().isEmpty() || entity.m_21223_() < entity.m_21233_() || showTarget) && !entity.m_213877_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public class EntityAttributeTracker {
        private final LivingEntity entity;
        private final AttributeState healthState;
        private final AttributeState energyState;
        private final AttributeState absorptionState;
        @Nullable
        private final AttributeState stunShieldState;
        private boolean canKeepUp;

        public EntityAttributeTracker(@Nullable LivingEntity entity, LivingEntityPatch<?> entitypatch) {
            this.entity = entity;
            this.healthState = new AttributeState(() -> Float.valueOf(entity.m_21233_()), () -> Float.valueOf(entity.m_21223_()));
            this.absorptionState = new AttributeState(() -> Float.valueOf(entity.m_21233_()), () -> Float.valueOf(entity.m_6103_()));
            AttributeState attributeState = this.stunShieldState = entitypatch != null ? new AttributeState(() -> Float.valueOf(entitypatch.getMaxStunShield()), () -> Float.valueOf(entitypatch.getStunShield())) : null;
            if (entity instanceof EnemyEntity) {
                EnemyEntity enemyEntity = (EnemyEntity)entity;
                this.energyState = new AttributeState(() -> Float.valueOf(enemyEntity.getMaxEnergy()), () -> Float.valueOf(enemyEntity.getEnergy()));
            } else {
                this.energyState = null;
            }
        }

        public void setKeepUp(boolean canKeepUp) {
            this.canKeepUp = canKeepUp;
        }

        public boolean canKeepUp() {
            return this.canKeepUp;
        }

        public void checkChange(float partialTick) {
            this.healthState.checkState(this.entity.f_19797_, partialTick);
            this.absorptionState.checkState(this.entity.f_19797_, partialTick);
            if (this.stunShieldState != null) {
                this.stunShieldState.checkState(this.entity.f_19797_, partialTick);
            }
            if (this.energyState != null) {
                this.energyState.checkState(this.entity.f_19797_, partialTick);
            }
        }

        public void tick() {
            this.healthState.tick(this.entity.f_19797_);
            this.absorptionState.tick(this.entity.f_19797_);
            if (this.stunShieldState != null) {
                this.stunShieldState.tick(this.entity.f_19797_);
            }
            if (this.energyState != null) {
                this.energyState.tick(this.entity.f_19797_);
            }
        }

        class AttributeState {
            final Supplier<Float> maxValueGetter;
            final Supplier<Float> currentValueGetter;
            float value;
            float valueO;
            int lastChangeTick;
            int animationFrames;

            AttributeState(Supplier<Float> maxValueGetter, Supplier<Float> currentValueGetter) {
                float initValue;
                this.maxValueGetter = maxValueGetter;
                this.currentValueGetter = currentValueGetter;
                this.value = initValue = currentValueGetter.get().floatValue();
                this.valueO = initValue;
                this.lastChangeTick = 0;
                this.animationFrames = 0;
            }

            void checkState(int tickCount, float partialTick) {
                float currentValue = this.currentValueGetter.get().floatValue();
                if (this.value != currentValue) {
                    if (this.animationFrames > 0) {
                        this.valueO = this.getAnimatedValue(tickCount, partialTick);
                    }
                    this.lastChangeTick = tickCount + 3;
                    this.animationFrames = currentValue == 0.0f ? 4 : Math.max(4, (int)(Math.abs(this.valueO - currentValue) / this.maxValueGetter.get().floatValue() * 10.0f));
                    this.value = currentValue;
                }
            }

            boolean hasAnimation() {
                return this.animationFrames > 0;
            }

            void tick(int tickCount) {
                if (tickCount - this.lastChangeTick >= this.animationFrames) {
                    this.animationFrames = 0;
                    this.valueO = this.value;
                }
            }

            float getAnimatedValue(int tickCount, float partialTick) {
                if (this.animationFrames == 0) {
                    return this.value;
                }
                if (tickCount < this.lastChangeTick) {
                    return this.valueO;
                }
                float divide = (float)(tickCount - this.lastChangeTick) / (float)this.animationFrames;
                float partial = divide + partialTick / (float)this.animationFrames;
                return this.valueO + (this.value - this.valueO) * partial;
            }
        }
    }
}

