/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.client.gui;

import com.merlin204.tde.entity.boss.BossEntity;
import com.merlin204.tde.util.TDEUIUtils;
import com.mojang.blaze3d.platform.Window;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TDEBossBar {
    public static final Map<UUID, Integer> BOSSES = new HashMap<UUID, Integer>();
    public static final ResourceLocation BAR_LONG = ResourceLocation.fromNamespaceAndPath((String)"tde", (String)"textures/gui/bossbar/bar_long.png");
    public static final ResourceLocation BAR_LONG_2 = ResourceLocation.fromNamespaceAndPath((String)"tde", (String)"textures/gui/bossbar/bar_long_2.png");
    public static final ResourceLocation BAR_HEALTH = ResourceLocation.fromNamespaceAndPath((String)"tde", (String)"textures/gui/bossbar/bar_health.png");
    public static final ResourceLocation BAR_HEALTH_B = ResourceLocation.fromNamespaceAndPath((String)"tde", (String)"textures/gui/bossbar/bar_health_b.png");
    public static final ResourceLocation BAR_ENERGY_1 = ResourceLocation.fromNamespaceAndPath((String)"tde", (String)"textures/gui/bossbar/bar_energy_1.png");
    public static final ResourceLocation BAR_ENERGY_1_B = ResourceLocation.fromNamespaceAndPath((String)"tde", (String)"textures/gui/bossbar/bar_energy_1_b.png");
    public static final ResourceLocation BAR_ENERGY_2 = ResourceLocation.fromNamespaceAndPath((String)"tde", (String)"textures/gui/bossbar/bar_energy_2.png");
    public static final ResourceLocation BAR_ENERGY_2_B = ResourceLocation.fromNamespaceAndPath((String)"tde", (String)"textures/gui/bossbar/bar_energy_2_b.png");

    @OnlyIn(value=Dist.CLIENT)
    public static boolean renderBossBar(GuiGraphics guiGraphics, LerpingBossEvent bossEvent, int x, int y) {
        Integer bossId;
        if (BOSSES.isEmpty()) {
            return false;
        }
        Entity boss = null;
        if (Minecraft.m_91087_().f_91073_ != null && (bossId = BOSSES.get(bossEvent.m_18860_())) != null) {
            boss = Minecraft.m_91087_().f_91073_.m_6815_(bossId.intValue());
        }
        if (boss instanceof BossEntity) {
            BossEntity bossEntity = (BossEntity)boss;
            TDEBossBar.drawHealth(guiGraphics, y, bossEntity);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawHealth(GuiGraphics guiGraphics, int y, BossEntity boss) {
        Window window = Minecraft.m_91087_().m_91268_();
        int screenWidth = window.m_85445_();
        TDEUIUtils.drawDoubleTDEBar(boss.getRenderHealth(), boss.m_21223_(), boss.m_21233_(), y, BAR_LONG, BAR_HEALTH, BAR_HEALTH_B, guiGraphics, 256, 16, 250, 16);
        if (boss.canEnergyRecover()) {
            TDEUIUtils.drawDoubleTDEBar(boss.getRenderEnergy(), boss.getEnergy(), boss.getMaxEnergy(), y + 15, BAR_LONG_2, BAR_ENERGY_1, BAR_ENERGY_1_B, guiGraphics, 256, 8, 254, 8);
        } else {
            TDEUIUtils.drawDoubleTDEBar(boss.getRenderEnergy(), boss.getEnergy(), boss.getMaxEnergy(), y + 15, BAR_LONG_2, BAR_ENERGY_2, BAR_ENERGY_2_B, guiGraphics, 256, 8, 254, 8);
        }
        Font font = Minecraft.m_91087_().f_91062_;
        Component name = boss.m_5446_();
        int nameWidth = font.m_92852_((FormattedText)name);
        int nameX = screenWidth / 2 - nameWidth / 2;
        int nameY = y - 8;
        guiGraphics.m_280614_(font, name, nameX, nameY, 0xFFFFFF, true);
    }
}

