/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.client;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import yesman.epicfight.api.utils.math.Vec3f;

@Mod.EventBusSubscriber(modid="tde", value={Dist.CLIENT})
public class CameraShake {
    private static final float DECAY_RATE = 0.95f;
    private static int shakeDuration = 0;
    private static float currentIntensity = 0.0f;
    private static float baseIntensity = 0.0f;
    private static float frequency = 3.0f;
    @Nullable
    private static Vec3 center;
    private static float radius;
    private static float minIntensity;

    public static void shake(int duration, float intensity, float frequency, Vec3 center, float radius) {
        if (FMLEnvironment.dist == Dist.CLIENT && intensity > baseIntensity) {
            shakeDuration = duration;
            baseIntensity = intensity;
            currentIntensity = intensity;
            CameraShake.frequency = frequency;
            CameraShake.center = center;
            CameraShake.radius = radius;
        }
    }

    @SubscribeEvent
    public static void onCameraUpdate(ViewportEvent.ComputeCameraAngles event) {
        if (CameraShake.shouldApplyShake()) {
            CameraShake.applyShakeEffect(event, (float)event.getPartialTick());
            CameraShake.updateShakeState();
        }
    }

    private static boolean shouldApplyShake() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return player != null && shakeDuration > 0 && !Minecraft.m_91087_().m_91104_() && center != null;
    }

    private static void applyShakeEffect(ViewportEvent.ComputeCameraAngles event, float partialTicks) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Vec3 playerPos = player.m_20182_();
        double distanceToCenter = playerPos.m_82554_(center);
        float distanceFactor = (float)Math.max(0.0, 1.0 - distanceToCenter / (double)radius);
        float attenuatedIntensity = currentIntensity * distanceFactor;
        float time = ((float)player.f_19797_ + partialTicks) * frequency;
        float progress = 1.0f - (float)shakeDuration / ((float)shakeDuration + partialTicks);
        float dynamicIntensity = attenuatedIntensity * (1.0f - progress * progress);
        Vec3f shakeOffset = CameraShake.calculateShakeOffset(time, dynamicIntensity);
        event.setPitch(event.getPitch() + shakeOffset.x);
        event.setYaw(event.getYaw() + shakeOffset.y);
        event.setRoll(event.getRoll() + shakeOffset.z);
    }

    private static Vec3f calculateShakeOffset(float time, float intensity) {
        return new Vec3f(intensity * (float)(Math.sin((double)time * 1.1) * (double)0.6f), intensity * (float)(Math.cos((double)time * 0.9) * (double)0.7f), intensity * (float)Math.sin((double)time * 1.3 + 2.0) * 0.4f);
    }

    private static void updateShakeState() {
        if (!Minecraft.m_91087_().m_91104_()) {
            currentIntensity *= 0.95f;
            currentIntensity = Math.max(currentIntensity, 0.01f);
            if (--shakeDuration <= 0) {
                CameraShake.reset();
            }
        }
    }

    public static void reset() {
        shakeDuration = 0;
        currentIntensity = 0.0f;
        baseIntensity = 0.0f;
    }
}

