/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.capabilitiy.player.campfiredata;

import com.merlin204.tde.block.respawncampfireblock.RespawnCampfireBlock;
import com.merlin204.tde.capabilitiy.player.TDEPlayerCapabilities;
import com.merlin204.tde.events.ForgeModEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CampfireManager {
    private static final Map<String, BlockPos> CAMPFIRE_POSITIONS = new ConcurrentHashMap<String, BlockPos>();

    public static void registerCampfire(String id, BlockPos pos) {
        CAMPFIRE_POSITIONS.put(id, pos);
    }

    public static BlockPos getCampfirePosition(String id) {
        return CAMPFIRE_POSITIONS.get(id);
    }

    public static void unlockCampfireForPlayer(Player player, String campfireId) {
        player.getCapability(TDEPlayerCapabilities.PLAYER_CAMPFIRE_DATA).ifPresent(data -> {
            Level level;
            BlockState state;
            data.unlockCampfire(campfireId);
            BlockPos campfirePos = CampfireManager.getCampfirePosition(campfireId);
            if (campfirePos != null && (state = (level = player.m_9236_()).m_8055_(campfirePos)).m_60734_() instanceof RespawnCampfireBlock) {
                level.m_7731_(campfirePos, (BlockState)state.m_61124_((Property)RespawnCampfireBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.getCapability(TDEPlayerCapabilities.PLAYER_CAMPFIRE_DATA).ifPresent(d -> ForgeModEvents.syncCampfireData(serverPlayer, d));
            }
        });
    }

    public static List<BlockPos> getUnlockedCampfiresForPlayer(Player player) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        player.getCapability(TDEPlayerCapabilities.PLAYER_CAMPFIRE_DATA).ifPresent(data -> data.getUnlockedCampfires().forEach(id -> {
            BlockPos pos = CampfireManager.getCampfirePosition(id);
            if (pos != null) {
                result.add(pos);
            }
        }));
        return result;
    }
}

