/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.capabilitiy.player.ability;

import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.capabilitiy.player.ability.PlayerAbilities;
import com.merlin204.tde.capabilitiy.player.ability.config.AbilityConfig;

public class PlayerAttribute {
    private final AbilityType type;
    private final PlayerAbilities parent;
    private float value;

    public PlayerAttribute(AbilityType type, PlayerAbilities parent) {
        this.type = type;
        this.parent = parent;
        this.value = type.min;
    }

    public float getCurrentMax() {
        return AbilityConfig.getEffectiveMax(this.type, this.parent);
    }

    public float get() {
        return this.value;
    }

    public void set(float value) {
        float max = this.getCurrentMax();
        this.value = Math.min(Math.max(value, this.type.min), max);
    }

    public void add(float amount) {
        float max = this.getCurrentMax();
        this.value = Math.min(this.value + amount, max);
    }

    public void sub(float amount) {
        this.value = Math.max(this.value - amount, this.type.min);
    }

    public void refreshMax() {
        float newMax = this.getCurrentMax();
        if (this.value > newMax) {
            this.value = newMax;
        }
    }
}

