/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.capabilitiy.player.ability;

import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.capabilitiy.player.ability.PlayerAttribute;
import com.merlin204.tde.network.NetworkHandler;
import com.merlin204.tde.network.client.ClientAbilitySyncPacket;
import com.merlin204.tde.network.server.AbilitySyncPacket;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PlayerAbilities {
    public final Map<AbilityType, PlayerAttribute> attributes = new EnumMap<AbilityType, PlayerAttribute>(AbilityType.class);

    public PlayerAbilities() {
        for (AbilityType type : AbilityType.values()) {
            this.attributes.put(type, new PlayerAttribute(type, this));
        }
    }

    public PlayerAttribute get(AbilityType type) {
        return this.attributes.get((Object)type);
    }

    public void saveToNBT(CompoundTag nbt) {
        CompoundTag attributesTag = new CompoundTag();
        this.attributes.forEach((type, attr) -> attributesTag.m_128350_(type.id, attr.get()));
        nbt.m_128365_("Abilities", (Tag)attributesTag);
    }

    public void loadFromNBT(CompoundTag nbt) {
        CompoundTag attributesTag = nbt.m_128469_("Abilities");
        this.attributes.forEach((type, attr) -> {
            if (attributesTag.m_128441_(type.id)) {
                float value = attributesTag.m_128457_(type.id);
                attr.set(value);
            }
        });
    }

    public PlayerAbilities getParent() {
        return this;
    }

    public void syncToClient(Player player) {
        if (!player.m_9236_().f_46443_) {
            CompoundTag data = new CompoundTag();
            this.saveToNBT(data);
            NetworkHandler.sendToClient(new AbilitySyncPacket(data), (ServerPlayer)player);
        }
    }

    public void syncToServer(Player player) {
        if (player.m_9236_().f_46443_) {
            CompoundTag data = new CompoundTag();
            this.saveToNBT(data);
            NetworkHandler.sendToServer(new ClientAbilitySyncPacket(data));
        }
    }
}

