/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.block.fogblock;

import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXHelper;
import com.merlin204.tde.block.FogBlockRegister;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.photon.PosEffect;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrierBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class FogBlock
extends BarrierBlock
implements EntityBlock {
    public static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    private int coolDown = 0;

    public FogBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.f_46443_) {
            FX fx = FXHelper.getFX((ResourceLocation)new ResourceLocation("photon:block/fog"));
            return (lvl, pos, blockState, blockEntity) -> {
                if (blockEntity instanceof FogBlockEntity) {
                    FogBlockEntity directedBarrierBlockEntity = (FogBlockEntity)blockEntity;
                    Direction facing = (Direction)pState.m_61143_((Property)FACING);
                    Minecraft mc = Minecraft.m_91087_();
                    LocalPlayer player = mc.f_91074_;
                    if (player != null) {
                        Vec3 center = directedBarrierBlockEntity.m_58899_().m_252807_();
                        PosEffect effect = new PosEffect(fx, player.m_9236_(), (Entity)player, new Vec3(center.f_82479_, center.f_82480_, center.f_82481_), 5, false, false);
                        effect.setRotation(0.0, facing.m_122435_(), 0.0);
                        effect.start();
                    }
                }
            };
        }
        return null;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (this.coolDown > 0) {
            --this.coolDown;
        }
        if (!level.f_46443_) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        Vec3 center = pos.m_252807_();
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        double x = (double)pos.m_123341_() + 0.5 + (double)facing.m_122429_() * 0.6;
        double y = (double)pos.m_123342_() + 0.5 + (double)facing.m_122430_() * 0.6;
        double z = (double)pos.m_123343_() + 0.5 + (double)facing.m_122431_() * 0.6;
        level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 0.0, 0.0, 0.0);
    }

    public void spawnEntity(ServerLevel level, BlockPos pos, Player player) {
        if (this.coolDown > 1) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FogBlockEntity) {
            FogBlockEntity barrierEntity = (FogBlockEntity)blockEntity;
            EntityType<?> entityType = barrierEntity.getEntityType();
            Vec3 offset = barrierEntity.getSpawnOffset();
            BlockState state = level.m_8055_(pos);
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            double spawnX = offset.f_82479_;
            double spawnY = offset.f_82480_;
            double spawnZ = offset.f_82481_;
            Entity entity = entityType.m_20615_((Level)level);
            if (entity != null) {
                entity.m_6034_(spawnX, spawnY, spawnZ);
                level.m_7967_(entity);
                if (entity instanceof EnemyEntity) {
                    EnemyEntity enemyEntity = (EnemyEntity)entity;
                    enemyEntity.m_6710_((LivingEntity)player);
                    enemyEntity.getEnemyPatch().rotateTo((Entity)player, 360.0f, false);
                }
            }
        }
        this.coolDown = 30;
    }

    public void clearSurroundingBarriers(ServerLevel level, BlockPos pos, int radius) {
        BlockState selfState = level.m_8055_(pos);
        if (!selfState.m_60713_((Block)this)) {
            return;
        }
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos targetPos = pos.m_7918_(x, y, z);
                    BlockState targetState = level.m_8055_(targetPos);
                    if (!(targetState.m_60734_() instanceof BarrierBlock)) continue;
                    level.m_46961_(targetPos, false);
                }
            }
        }
        level.m_46961_(pos, false);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new FogBlockEntity(blockPos, blockState);
    }

    public boolean m_7420_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return true;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.INVISIBLE;
    }

    public float m_7749_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return 1.0f;
    }

    public static class FogBlockEntity
    extends BlockEntity {
        private EntityType<?> entityType = EntityType.f_20515_;
        private Vec3 spawnOffset = new Vec3(0.0, 0.5, 1.0);

        public FogBlockEntity(BlockPos pos, BlockState state) {
            super((BlockEntityType)FogBlockRegister.FOG_GATE_BLOCK_ENTITY.get(), pos, state);
        }

        public EntityType<?> getEntityType() {
            return this.entityType;
        }

        public void setEntityType(EntityType<?> entityType) {
            this.entityType = entityType;
            this.m_6596_();
        }

        public Vec3 getSpawnOffset() {
            return this.spawnOffset;
        }

        public void setSpawnOffset(Vec3 spawnOffset) {
            this.spawnOffset = spawnOffset;
            this.m_6596_();
        }

        protected void m_183515_(CompoundTag tag) {
            super.m_183515_(tag);
            tag.m_128359_("EntityType", EntityType.m_20613_(this.entityType).toString());
            tag.m_128347_("OffsetX", this.spawnOffset.f_82479_);
            tag.m_128347_("OffsetY", this.spawnOffset.f_82480_);
            tag.m_128347_("OffsetZ", this.spawnOffset.f_82481_);
        }

        public void m_142466_(CompoundTag tag) {
            super.m_142466_(tag);
            if (tag.m_128441_("EntityType")) {
                ResourceLocation entityId = new ResourceLocation(tag.m_128461_("EntityType"));
                Optional<EntityType> type = ForgeRegistries.ENTITY_TYPES.getDelegate(entityId).map(d -> (EntityType)d.get());
                type.ifPresent(t -> {
                    this.entityType = t;
                });
            }
            if (tag.m_128441_("OffsetX") && tag.m_128441_("OffsetY") && tag.m_128441_("OffsetZ")) {
                this.spawnOffset = new Vec3(tag.m_128459_("OffsetX"), tag.m_128459_("OffsetY"), tag.m_128459_("OffsetZ"));
            }
        }
    }
}

