/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.tde.block.fogblock;

import com.merlin204.tde.block.fogblock.FogBlock;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;

public class BarrierConfiguratorItem
extends Item {
    private static final Lazy<EntityType<?>> DEFAULT_ENTITY = Lazy.of(() -> (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation("tde:b1")));
    private static final Vec3 DEFAULT_OFFSET = new Vec3(1288.0, 247.0, 1118.0);
    private static final int CONFIG_RADIUS = 3;

    public BarrierConfiguratorItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.m_5776_()) {
            BlockPos playerPos = player.m_20183_();
            AABB area = new AABB(playerPos.m_7918_(-3, -3, -3), playerPos.m_7918_(3, 3, 3));
            EntityType<?> entityType = BarrierConfiguratorItem.getStoredEntityType(stack);
            Vec3 offset = BarrierConfiguratorItem.getStoredOffset(stack);
            int configuredBlocks = 0;
            int x = (int)area.f_82288_;
            while ((double)x <= area.f_82291_) {
                int y = (int)area.f_82289_;
                while ((double)y <= area.f_82292_) {
                    int z = (int)area.f_82290_;
                    while ((double)z <= area.f_82293_) {
                        BlockEntity blockEntity;
                        BlockPos pos = new BlockPos(x, y, z);
                        Block block = level.m_8055_(pos).m_60734_();
                        if (block instanceof FogBlock && (blockEntity = level.m_7702_(pos)) instanceof FogBlock.FogBlockEntity) {
                            FogBlock.FogBlockEntity barrierEntity = (FogBlock.FogBlockEntity)blockEntity;
                            barrierEntity.setEntityType(entityType);
                            barrierEntity.setSpawnOffset(offset);
                            ++configuredBlocks;
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            if (configuredBlocks > 0) {
                player.m_5661_((Component)Component.m_237113_((String)("\u5df2\u914d\u7f6e " + configuredBlocks + " \u4e2a\u96fe\u95e8\u3002\u751f\u6210: " + EntityType.m_20613_(entityType).toString())), true);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            player.m_5661_((Component)Component.m_237113_((String)"\u9644\u8fd1\u6ca1\u6709\u627e\u5230\u5c4f\u969c\u65b9\u5757\uff01"), true);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        EntityType<?> entityType = BarrierConfiguratorItem.getStoredEntityType(stack);
        Vec3 offset = BarrierConfiguratorItem.getStoredOffset(stack);
        tooltip.add((Component)Component.m_237113_((String)("\u914d\u7f6e\u5b9e\u4f53: " + EntityType.m_20613_(entityType).toString())));
        tooltip.add((Component)Component.m_237113_((String)("\u751f\u6210\u4f4d\u7f6e: " + String.format("(%.1f, %.1f, %.1f)", offset.f_82479_, offset.f_82480_, offset.f_82481_))));
        tooltip.add((Component)Component.m_237113_((String)"\u53f3\u952e\u70b9\u51fb\u5c4f\u969c\u65b9\u5757\u4ee5\u5e94\u7528\u914d\u7f6e"));
    }

    public static EntityType<?> getStoredEntityType(ItemStack stack) {
        ResourceLocation entityId;
        Optional<EntityType> entityType;
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("EntityType") && (entityType = ForgeRegistries.ENTITY_TYPES.getDelegate(entityId = new ResourceLocation(tag.m_128461_("EntityType"))).map(d -> (EntityType)d.get())).isPresent()) {
            return entityType.get();
        }
        return (EntityType)DEFAULT_ENTITY.get();
    }

    public static Vec3 getStoredOffset(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("OffsetX") && tag.m_128441_("OffsetY") && tag.m_128441_("OffsetZ")) {
            return new Vec3(tag.m_128459_("OffsetX"), tag.m_128459_("OffsetY"), tag.m_128459_("OffsetZ"));
        }
        return DEFAULT_OFFSET;
    }
}

