/*
 * Decompiled with CFR 0.152.
 */
package com.logistics.fisher.modbus.handler;

import com.logistics.fisher.modbus.ModbusServer;
import com.logistics.fisher.modbus.entity.ModbusFrame;
import com.logistics.fisher.modbus.entity.ModbusFunction;
import com.logistics.fisher.modbus.entity.ModbusHeader;
import com.logistics.fisher.modbus.entity.func.AbstractFunction;
import com.logistics.fisher.modbus.entity.func.WriteSingleCoil;
import com.logistics.fisher.modbus.entity.func.WriteSingleRegister;
import com.logistics.fisher.modbus.entity.func.request.ReadCoilsRequest;
import com.logistics.fisher.modbus.entity.func.request.ReadDiscreteInputsRequest;
import com.logistics.fisher.modbus.entity.func.request.ReadHoldingRegistersRequest;
import com.logistics.fisher.modbus.entity.func.request.ReadInputRegistersRequest;
import com.logistics.fisher.modbus.entity.func.request.WriteMultipleCoilsRequest;
import com.logistics.fisher.modbus.entity.func.request.WriteMultipleRegistersRequest;
import com.logistics.fisher.modbus.entity.func.response.ReadCoilsResponse;
import com.logistics.fisher.modbus.entity.func.response.ReadDiscreteInputsResponse;
import com.logistics.fisher.modbus.entity.func.response.ReadHoldingRegistersResponse;
import com.logistics.fisher.modbus.entity.func.response.ReadInputRegistersResponse;
import com.logistics.fisher.modbus.entity.func.response.WriteMultipleCoilsResponse;
import com.logistics.fisher.modbus.entity.func.response.WriteMultipleRegistersResponse;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ModbusRequestHandler
extends SimpleChannelInboundHandler<ModbusFrame> {
    private static final Logger logger = Logger.getLogger(ModbusRequestHandler.class.getSimpleName());
    private ModbusServer server;

    public void setServer(ModbusServer server) {
        this.server = server;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.warning(cause.getLocalizedMessage());
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.server.removeClient(ctx.channel());
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.server.addClient(ctx.channel());
    }

    protected void channelRead0(ChannelHandlerContext ctx, ModbusFrame frame) throws Exception {
        ModbusFunction response;
        AbstractFunction request;
        Channel channel = ctx.channel();
        ModbusFunction function = frame.getFunction();
        logger.log(Level.FINER, function.toString());
        if (function instanceof WriteSingleCoil) {
            request = (WriteSingleCoil)function;
            response = this.writeSingleCoil((WriteSingleCoil)request);
        } else if (function instanceof WriteSingleRegister) {
            request = (WriteSingleRegister)function;
            response = this.writeSingleRegister((WriteSingleRegister)request);
        } else if (function instanceof ReadCoilsRequest) {
            request = (ReadCoilsRequest)function;
            response = this.readCoilsRequest((ReadCoilsRequest)request);
        } else if (function instanceof ReadDiscreteInputsRequest) {
            request = (ReadDiscreteInputsRequest)function;
            response = this.readDiscreteInputsRequest((ReadDiscreteInputsRequest)request);
        } else if (function instanceof ReadInputRegistersRequest) {
            request = (ReadInputRegistersRequest)function;
            response = this.readInputRegistersRequest((ReadInputRegistersRequest)request);
        } else if (function instanceof ReadHoldingRegistersRequest) {
            request = (ReadHoldingRegistersRequest)function;
            response = this.readHoldingRegistersRequest((ReadHoldingRegistersRequest)request);
        } else if (function instanceof WriteMultipleRegistersRequest) {
            request = (WriteMultipleRegistersRequest)function;
            response = this.writeMultipleRegistersRequest((WriteMultipleRegistersRequest)request);
        } else if (function instanceof WriteMultipleCoilsRequest) {
            request = (WriteMultipleCoilsRequest)function;
            response = this.writeMultipleCoilsRequest((WriteMultipleCoilsRequest)request);
        } else {
            throw new UnsupportedOperationException("Function not supported!");
        }
        ModbusHeader header = new ModbusHeader(frame.getHeader().getTransactionIdentifier(), frame.getHeader().getProtocolIdentifier(), response.calculateLength(), frame.getHeader().getUnitIdentifier());
        ModbusFrame responseFrame = new ModbusFrame(header, response);
        channel.write((Object)responseFrame);
    }

    protected abstract WriteSingleCoil writeSingleCoil(WriteSingleCoil var1);

    protected abstract WriteSingleRegister writeSingleRegister(WriteSingleRegister var1);

    protected abstract ReadCoilsResponse readCoilsRequest(ReadCoilsRequest var1);

    protected abstract ReadDiscreteInputsResponse readDiscreteInputsRequest(ReadDiscreteInputsRequest var1);

    protected abstract ReadInputRegistersResponse readInputRegistersRequest(ReadInputRegistersRequest var1);

    protected abstract ReadHoldingRegistersResponse readHoldingRegistersRequest(ReadHoldingRegistersRequest var1);

    protected abstract WriteMultipleRegistersResponse writeMultipleRegistersRequest(WriteMultipleRegistersRequest var1);

    protected abstract WriteMultipleCoilsResponse writeMultipleCoilsRequest(WriteMultipleCoilsRequest var1);
}

