/*
 * Decompiled with CFR 0.152.
 */
package com.logistics.fisher.modbus.handler;

import com.logistics.fisher.modbus.entity.ModbusFrame;
import com.logistics.fisher.modbus.handler.ModbusDecoder;
import com.logistics.fisher.modbus.handler.ModbusEncoder;
import com.logistics.fisher.modbus.handler.ModbusRequestHandler;
import com.logistics.fisher.modbus.handler.ModbusResponseHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;

public class ModbusChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private final SimpleChannelInboundHandler handler;

    public ModbusChannelInitializer(ModbusRequestHandler handler) {
        this.handler = handler;
    }

    public ModbusChannelInitializer(ModbusResponseHandler handler) {
        this.handler = handler;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("framer", (ChannelHandler)new LengthFieldBasedFrameDecoder(260, 4, 2));
        pipeline.addLast("encoder", (ChannelHandler)new ModbusEncoder());
        pipeline.addLast("decoder", (ChannelHandler)new ModbusDecoder(this.handler instanceof ModbusRequestHandler));
        if (this.handler instanceof ModbusRequestHandler) {
            pipeline.addLast("requestHandler", (ChannelHandler)this.handler);
        } else if (this.handler instanceof ModbusResponseHandler) {
            pipeline.addLast("responseHandler", (ChannelHandler)this.handler);
        } else {
            pipeline.addLast("responseHandler", (ChannelHandler)new ModbusResponseHandler(){

                @Override
                public void newResponse(ModbusFrame frame) {
                }
            });
        }
    }
}

