/*
 * Decompiled with CFR 0.152.
 */
package com.logistics.fisher.modbus.example;

import com.logistics.fisher.modbus.entity.func.WriteSingleCoil;
import com.logistics.fisher.modbus.entity.func.WriteSingleRegister;
import com.logistics.fisher.modbus.entity.func.request.ReadCoilsRequest;
import com.logistics.fisher.modbus.entity.func.request.ReadDiscreteInputsRequest;
import com.logistics.fisher.modbus.entity.func.request.ReadHoldingRegistersRequest;
import com.logistics.fisher.modbus.entity.func.request.ReadInputRegistersRequest;
import com.logistics.fisher.modbus.entity.func.request.WriteMultipleCoilsRequest;
import com.logistics.fisher.modbus.entity.func.request.WriteMultipleRegistersRequest;
import com.logistics.fisher.modbus.entity.func.response.ReadCoilsResponse;
import com.logistics.fisher.modbus.entity.func.response.ReadDiscreteInputsResponse;
import com.logistics.fisher.modbus.entity.func.response.ReadHoldingRegistersResponse;
import com.logistics.fisher.modbus.entity.func.response.ReadInputRegistersResponse;
import com.logistics.fisher.modbus.entity.func.response.WriteMultipleCoilsResponse;
import com.logistics.fisher.modbus.entity.func.response.WriteMultipleRegistersResponse;
import com.logistics.fisher.modbus.handler.ModbusRequestHandler;
import java.util.BitSet;

public class ModbusRequestHandlerExample
extends ModbusRequestHandler {
    @Override
    protected WriteSingleCoil writeSingleCoil(WriteSingleCoil request) {
        return request;
    }

    @Override
    protected WriteSingleRegister writeSingleRegister(WriteSingleRegister request) {
        return request;
    }

    @Override
    protected ReadCoilsResponse readCoilsRequest(ReadCoilsRequest request) {
        BitSet coils = new BitSet(request.getQuantityOfCoils());
        coils.set(0);
        coils.set(5);
        coils.set(8);
        return new ReadCoilsResponse(coils);
    }

    @Override
    protected ReadDiscreteInputsResponse readDiscreteInputsRequest(ReadDiscreteInputsRequest request) {
        BitSet coils = new BitSet(request.getQuantityOfCoils());
        coils.set(0);
        coils.set(5);
        coils.set(8);
        return new ReadDiscreteInputsResponse(coils);
    }

    @Override
    protected ReadInputRegistersResponse readInputRegistersRequest(ReadInputRegistersRequest request) {
        int[] registers = new int[request.getQuantityOfInputRegisters()];
        registers[0] = 65535;
        registers[1] = 61680;
        registers[2] = 3855;
        return new ReadInputRegistersResponse(registers);
    }

    @Override
    protected ReadHoldingRegistersResponse readHoldingRegistersRequest(ReadHoldingRegistersRequest request) {
        int[] registers = new int[request.getQuantityOfInputRegisters()];
        registers[0] = 65535;
        registers[1] = 61680;
        registers[2] = 3855;
        return new ReadHoldingRegistersResponse(registers);
    }

    @Override
    protected WriteMultipleRegistersResponse writeMultipleRegistersRequest(WriteMultipleRegistersRequest request) {
        return new WriteMultipleRegistersResponse(request.getStartingAddress(), request.getQuantityOfRegisters());
    }

    @Override
    protected WriteMultipleCoilsResponse writeMultipleCoilsRequest(WriteMultipleCoilsRequest request) {
        return new WriteMultipleCoilsResponse(request.getStartingAddress(), request.getQuantityOfOutputs());
    }
}

