/*
 * Decompiled with CFR 0.152.
 */
package com.logistics.fisher.modbus.example;

import com.logistics.fisher.modbus.ModbusClient;
import com.logistics.fisher.modbus.ModbusServer;
import com.logistics.fisher.modbus.entity.ModbusFrame;
import com.logistics.fisher.modbus.entity.exception.ConnectionException;
import com.logistics.fisher.modbus.entity.exception.ErrorResponseException;
import com.logistics.fisher.modbus.entity.exception.NoResponseException;
import com.logistics.fisher.modbus.entity.func.Util;
import com.logistics.fisher.modbus.entity.func.WriteSingleCoil;
import com.logistics.fisher.modbus.entity.func.WriteSingleRegister;
import com.logistics.fisher.modbus.entity.func.request.ReadCoilsRequest;
import com.logistics.fisher.modbus.entity.func.request.ReadDiscreteInputsRequest;
import com.logistics.fisher.modbus.entity.func.request.ReadHoldingRegistersRequest;
import com.logistics.fisher.modbus.entity.func.request.ReadInputRegistersRequest;
import com.logistics.fisher.modbus.entity.func.request.WriteMultipleCoilsRequest;
import com.logistics.fisher.modbus.entity.func.request.WriteMultipleRegistersRequest;
import com.logistics.fisher.modbus.entity.func.response.ReadCoilsResponse;
import com.logistics.fisher.modbus.entity.func.response.ReadDiscreteInputsResponse;
import com.logistics.fisher.modbus.entity.func.response.ReadHoldingRegistersResponse;
import com.logistics.fisher.modbus.entity.func.response.ReadInputRegistersResponse;
import com.logistics.fisher.modbus.entity.func.response.WriteMultipleCoilsResponse;
import com.logistics.fisher.modbus.entity.func.response.WriteMultipleRegistersResponse;
import com.logistics.fisher.modbus.handler.ModbusRequestHandler;
import com.logistics.fisher.modbus.handler.ModbusResponseHandler;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.BitSet;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class ExampleUI
extends JFrame {
    private static ModbusClient modbusClient;
    private static ModbusServer modbusServer;
    private boolean asyncClient;
    private JButton btConnect;
    private JButton btConnectAsync;
    private JButton btListen;
    private JButton btReadCoils;
    private JButton btReadDiscreteInputs;
    private JButton btReadHoldingRegisters;
    private JButton btReadInputRegisters;
    private JButton btWriteCoil;
    private JButton btWriteSingleRegister;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JLabel lbClient;
    private JLabel lbClients;
    private JPanel pConnection;
    private JTextArea taLog;
    private JTextField tfAddr;
    private JTextField tfAddrWrite;
    private JTextField tfHost;
    private JTextField tfPort;
    private JTextField tfQuantity;
    private JTextField tfRemotePort;
    private JTextField tfValueWrite;

    public ExampleUI() {
        this.initComponents();
    }

    private void callModbusFunction(int functionCode) {
        if (modbusClient == null) {
            return;
        }
        int addr = Integer.parseInt(this.tfAddr.getText());
        int quantity = Integer.parseInt(this.tfQuantity.getText());
        int addrWrite = Integer.parseInt(this.tfAddrWrite.getText());
        int valueWrite = Integer.parseInt(this.tfValueWrite.getText());
        try {
            String response = "FUNCTION NOT SUPPORTED";
            switch (functionCode) {
                case 1: {
                    if (this.asyncClient) {
                        modbusClient.readCoilsAsync(addr, quantity);
                        break;
                    }
                    ReadCoilsResponse readCoilsResponse = modbusClient.readCoils(addr, quantity);
                    response = Util.getBinaryString(readCoilsResponse.getByteCount(), readCoilsResponse.getCoilStatus());
                    break;
                }
                case 2: {
                    if (this.asyncClient) {
                        modbusClient.readDiscreteInputs(addr, quantity);
                        break;
                    }
                    ReadDiscreteInputsResponse readDiscreteInputs = modbusClient.readDiscreteInputs(addr, quantity);
                    response = Util.getBinaryString(readDiscreteInputs.getByteCount(), readDiscreteInputs.getInputStatus());
                    break;
                }
                case 3: {
                    if (this.asyncClient) {
                        modbusClient.readHoldingRegisters(addr, quantity);
                        break;
                    }
                    ReadHoldingRegistersResponse readHoldingRegistersResponse = modbusClient.readHoldingRegisters(addr, quantity);
                    response = Arrays.toString(readHoldingRegistersResponse.getRegisters());
                    break;
                }
                case 4: {
                    if (this.asyncClient) {
                        modbusClient.readInputRegisters(addr, quantity);
                        break;
                    }
                    ReadInputRegistersResponse readInputRegistersResponse = modbusClient.readInputRegisters(addr, quantity);
                    response = Arrays.toString(readInputRegistersResponse.getInputRegisters());
                    break;
                }
                case 5: {
                    if (this.asyncClient) {
                        modbusClient.writeSingleCoil(addrWrite, valueWrite > 0);
                        break;
                    }
                    WriteSingleCoil writeSingleCoil = modbusClient.writeSingleCoil(addrWrite, valueWrite > 0);
                    response = writeSingleCoil.toString();
                    break;
                }
                case 6: {
                    if (this.asyncClient) {
                        modbusClient.writeSingleRegister(addrWrite, valueWrite);
                        break;
                    }
                    WriteSingleRegister writeSingleRegister = modbusClient.writeSingleRegister(addrWrite, valueWrite);
                    response = writeSingleRegister.toString();
                }
            }
            if (!this.asyncClient) {
                this.taLog.append(response + "\n");
            }
        }
        catch (ConnectionException | ErrorResponseException | NoResponseException ex) {
            this.taLog.append(ex.getLocalizedMessage() + "\n");
        }
    }

    private void setupClient(ModbusResponseHandler handler) {
        if (modbusClient != null) {
            modbusClient.close();
        }
        this.asyncClient = handler != null;
        String host = this.tfHost.getText();
        String port = this.tfRemotePort.getText();
        modbusClient = new ModbusClient(host, Integer.valueOf(port));
        modbusClient.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("connectionState")) {
                    ModbusClient.CONNECTION_STATES state = (ModbusClient.CONNECTION_STATES)((Object)evt.getNewValue());
                    switch (state) {
                        case connected: {
                            ExampleUI.this.lbClient.setText("connected");
                            break;
                        }
                        case notConnected: {
                            ExampleUI.this.lbClient.setText("not connected");
                            break;
                        }
                        case pending: {
                            ExampleUI.this.lbClient.setText("pending");
                        }
                    }
                }
            }
        });
        try {
            modbusClient.setup(handler);
        }
        catch (ConnectionException ex) {
            JOptionPane.showMessageDialog(this, ex.getLocalizedMessage());
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.pConnection = new JPanel();
        this.btListen = new JButton();
        this.tfHost = new JTextField();
        this.tfPort = new JTextField();
        this.btConnect = new JButton();
        this.tfRemotePort = new JTextField();
        this.lbClient = new JLabel();
        this.lbClients = new JLabel();
        this.btConnectAsync = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.taLog = new JTextArea();
        this.jPanel1 = new JPanel();
        this.btReadInputRegisters = new JButton();
        this.btReadHoldingRegisters = new JButton();
        this.btReadCoils = new JButton();
        this.tfAddr = new JTextField();
        this.btReadDiscreteInputs = new JButton();
        this.tfQuantity = new JTextField();
        this.jPanel2 = new JPanel();
        this.tfAddrWrite = new JTextField();
        this.tfValueWrite = new JTextField();
        this.btWriteCoil = new JButton();
        this.btWriteSingleRegister = new JButton();
        this.jLabel1.setText("jLabel1");
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ExampleUI.this.formWindowClosing(evt);
            }
        });
        this.pConnection.setBorder(BorderFactory.createTitledBorder("Connection"));
        this.btListen.setText("listen");
        this.btListen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExampleUI.this.btListenActionPerformed(evt);
            }
        });
        this.tfHost.setText("10.0.1.55");
        this.tfPort.setText("30502");
        this.btConnect.setText("connect");
        this.btConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExampleUI.this.btConnectActionPerformed(evt);
            }
        });
        this.tfRemotePort.setText("502");
        this.lbClient.setText("not connected");
        this.lbClients.setText("server down");
        this.btConnectAsync.setText("connect async");
        this.btConnectAsync.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExampleUI.this.btConnectAsyncActionPerformed(evt);
            }
        });
        GroupLayout pConnectionLayout = new GroupLayout(this.pConnection);
        this.pConnection.setLayout(pConnectionLayout);
        pConnectionLayout.setHorizontalGroup(pConnectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pConnectionLayout.createSequentialGroup().addContainerGap().addGroup(pConnectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pConnectionLayout.createSequentialGroup().addComponent(this.tfHost, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfRemotePort, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btConnect).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btConnectAsync).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbClient, -1, -1, Short.MAX_VALUE).addGap(318, 318, 318)).addGroup(pConnectionLayout.createSequentialGroup().addComponent(this.tfPort, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btListen, -2, 94, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbClients, -1, -1, Short.MAX_VALUE))).addGap(177, 177, 177)));
        pConnectionLayout.setVerticalGroup(pConnectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pConnectionLayout.createSequentialGroup().addContainerGap().addGroup(pConnectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pConnectionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbClients).addComponent(this.btListen)).addComponent(this.tfPort, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addGap(17, 17, 17).addGroup(pConnectionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btConnect).addComponent(this.tfRemotePort, -2, -1, -2).addComponent(this.tfHost, -2, -1, -2).addComponent(this.lbClient).addComponent(this.btConnectAsync)).addContainerGap()));
        this.taLog.setColumns(20);
        this.taLog.setRows(5);
        this.jScrollPane1.setViewportView(this.taLog);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Read"));
        this.btReadInputRegisters.setText("ReadInputRegisters");
        this.btReadInputRegisters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExampleUI.this.btReadInputRegistersActionPerformed(evt);
            }
        });
        this.btReadHoldingRegisters.setText("ReadHoldingRegisters");
        this.btReadHoldingRegisters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExampleUI.this.btReadHoldingRegistersActionPerformed(evt);
            }
        });
        this.btReadCoils.setText("ReadCoils");
        this.btReadCoils.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExampleUI.this.btReadCoilsActionPerformed(evt);
            }
        });
        this.tfAddr.setText("12288");
        this.btReadDiscreteInputs.setText("ReadDiscreteInputs");
        this.btReadDiscreteInputs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExampleUI.this.btReadDiscreteInputsActionPerformed(evt);
            }
        });
        this.tfQuantity.setText("10");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.btReadCoils).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btReadInputRegisters)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.btReadDiscreteInputs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btReadHoldingRegisters))).addGap(46, 46, 46).addComponent(this.tfAddr, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfQuantity, -2, 56, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btReadCoils).addComponent(this.btReadInputRegisters)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btReadDiscreteInputs).addComponent(this.btReadHoldingRegisters))).addGroup(jPanel1Layout.createSequentialGroup().addGap(12, 12, 12).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfAddr, -2, -1, -2).addComponent(this.tfQuantity, -2, -1, -2)))).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Write"));
        this.tfAddrWrite.setText("12288");
        this.tfValueWrite.setText("10");
        this.btWriteCoil.setText("WriteSingleCoil");
        this.btWriteCoil.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExampleUI.this.btWriteCoilActionPerformed(evt);
            }
        });
        this.btWriteSingleRegister.setText("WriteSingleRegister");
        this.btWriteSingleRegister.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExampleUI.this.btWriteSingleRegisterActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.btWriteCoil).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btWriteSingleRegister).addGap(18, 18, 18).addComponent(this.tfAddrWrite, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfValueWrite, -2, 56, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfAddrWrite, -2, -1, -2).addComponent(this.tfValueWrite, -2, -1, -2)).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btWriteCoil).addComponent(this.btWriteSingleRegister))).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.pConnection, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.pConnection, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 240, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void btListenActionPerformed(ActionEvent evt) {
        String port = this.tfPort.getText();
        if (modbusServer != null) {
            modbusServer.close();
        }
        modbusServer = new ModbusServer(Integer.valueOf(port));
        modbusServer.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("connectionState")) {
                    ModbusServer.CONNECTION_STATES state = (ModbusServer.CONNECTION_STATES)((Object)evt.getNewValue());
                    switch (state) {
                        case down: {
                            ExampleUI.this.lbClients.setText("server down");
                            break;
                        }
                        case listening: {
                            ExampleUI.this.lbClients.setText("listening");
                            break;
                        }
                        case clientsConnected: {
                            ExampleUI.this.lbClients.setText(modbusServer.getClientChannels().size() + " clients connected");
                        }
                    }
                }
            }
        });
        try {
            modbusServer.setup(new ModbusRequestHandler(){

                @Override
                protected WriteSingleCoil writeSingleCoil(WriteSingleCoil request) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                protected WriteSingleRegister writeSingleRegister(WriteSingleRegister request) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                protected ReadCoilsResponse readCoilsRequest(ReadCoilsRequest request) {
                    BitSet coils = new BitSet(request.getQuantityOfCoils());
                    for (int i = 0; i < request.getQuantityOfCoils(); ++i) {
                        coils.set(i);
                    }
                    return new ReadCoilsResponse(coils);
                }

                @Override
                protected ReadDiscreteInputsResponse readDiscreteInputsRequest(ReadDiscreteInputsRequest request) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                protected ReadInputRegistersResponse readInputRegistersRequest(ReadInputRegistersRequest request) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                protected ReadHoldingRegistersResponse readHoldingRegistersRequest(ReadHoldingRegistersRequest request) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                protected WriteMultipleRegistersResponse writeMultipleRegistersRequest(WriteMultipleRegistersRequest request) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                protected WriteMultipleCoilsResponse writeMultipleCoilsRequest(WriteMultipleCoilsRequest request) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            });
        }
        catch (ConnectionException ex) {
            JOptionPane.showMessageDialog(this, ex.getLocalizedMessage());
        }
    }

    private void btConnectActionPerformed(ActionEvent evt) {
        this.setupClient(null);
    }

    private void btReadCoilsActionPerformed(ActionEvent evt) {
        this.callModbusFunction(1);
    }

    private void formWindowClosing(WindowEvent evt) {
        if (modbusServer != null) {
            modbusServer.close();
        }
    }

    private void btReadDiscreteInputsActionPerformed(ActionEvent evt) {
        this.callModbusFunction(2);
    }

    private void btReadInputRegistersActionPerformed(ActionEvent evt) {
        this.callModbusFunction(4);
    }

    private void btReadHoldingRegistersActionPerformed(ActionEvent evt) {
        this.callModbusFunction(3);
    }

    private void btWriteCoilActionPerformed(ActionEvent evt) {
        this.callModbusFunction(5);
    }

    private void btWriteSingleRegisterActionPerformed(ActionEvent evt) {
        this.callModbusFunction(6);
    }

    private void btConnectAsyncActionPerformed(ActionEvent evt) {
        ModbusResponseHandler handler = new ModbusResponseHandler(){

            @Override
            public void newResponse(ModbusFrame frame) {
                ExampleUI.this.taLog.append(frame.toString() + "\n");
            }
        };
        this.setupClient(handler);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ExampleUI().setVisible(true);
            }
        });
    }
}

