/*
 * Decompiled with CFR 0.152.
 */
package com.logistics.fisher.modbus.entity.func.response;

import com.logistics.fisher.modbus.entity.ModbusFunction;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

public class ReadInputRegistersResponse
extends ModbusFunction {
    private short byteCount;
    private int[] inputRegisters;

    public ReadInputRegistersResponse() {
        super((short)4);
    }

    public ReadInputRegistersResponse(int[] inputRegisters) {
        super((short)4);
        if (inputRegisters.length > 125) {
            throw new IllegalArgumentException();
        }
        this.byteCount = (short)(inputRegisters.length * 2);
        this.inputRegisters = inputRegisters;
    }

    public int[] getInputRegisters() {
        return this.inputRegisters;
    }

    public short getByteCount() {
        return this.byteCount;
    }

    @Override
    public int calculateLength() {
        return 2 + this.byteCount;
    }

    @Override
    public ByteBuf encode() {
        ByteBuf buf = Unpooled.buffer((int)this.calculateLength());
        buf.writeByte((int)this.getFunctionCode());
        buf.writeByte((int)this.byteCount);
        for (int i = 0; i < this.inputRegisters.length; ++i) {
            buf.writeShort(this.inputRegisters[i]);
        }
        return buf;
    }

    @Override
    public void decode(ByteBuf data) {
        this.byteCount = data.readUnsignedByte();
        this.inputRegisters = new int[this.byteCount / 2];
        for (int i = 0; i < this.inputRegisters.length; ++i) {
            this.inputRegisters[i] = data.readUnsignedShort();
        }
    }

    public String toString() {
        StringBuilder registers = new StringBuilder();
        registers.append("{");
        for (int i = 0; i < this.inputRegisters.length; ++i) {
            registers.append("register_");
            registers.append(i);
            registers.append("=");
            registers.append(this.inputRegisters[i]);
            registers.append(", ");
        }
        registers.delete(registers.length() - 2, registers.length());
        registers.append("}");
        return "ReadInputRegistersResponse{byteCount=" + this.byteCount + ", inputRegisters=" + registers + '}';
    }
}

