/*
 * Decompiled with CFR 0.152.
 */
package com.logistics.fisher.modbus.entity.func.response;

import com.logistics.fisher.modbus.entity.ModbusFunction;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

public class ReadHoldingRegistersResponse
extends ModbusFunction {
    private short byteCount;
    private int[] registers;

    public ReadHoldingRegistersResponse() {
        super((short)3);
    }

    public ReadHoldingRegistersResponse(int[] registers) {
        super((short)3);
        if (registers.length > 125) {
            throw new IllegalArgumentException();
        }
        this.byteCount = (short)(registers.length * 2);
        this.registers = registers;
    }

    public int[] getRegisters() {
        return this.registers;
    }

    public short getByteCount() {
        return this.byteCount;
    }

    @Override
    public int calculateLength() {
        return 2 + this.byteCount;
    }

    @Override
    public ByteBuf encode() {
        ByteBuf buf = Unpooled.buffer((int)this.calculateLength());
        buf.writeByte((int)this.getFunctionCode());
        buf.writeByte((int)this.byteCount);
        for (int i = 0; i < this.registers.length; ++i) {
            buf.writeShort(this.registers[i]);
        }
        return buf;
    }

    @Override
    public void decode(ByteBuf data) {
        this.byteCount = data.readUnsignedByte();
        this.registers = new int[this.byteCount / 2];
        for (int i = 0; i < this.registers.length; ++i) {
            this.registers[i] = data.readUnsignedShort();
        }
    }

    public String toString() {
        StringBuilder registersStr = new StringBuilder();
        registersStr.append("{");
        for (int i = 0; i < this.registers.length; ++i) {
            registersStr.append("register_");
            registersStr.append(i);
            registersStr.append("=");
            registersStr.append(this.registers[i]);
            registersStr.append(", ");
        }
        registersStr.delete(registersStr.length() - 2, registersStr.length());
        registersStr.append("}");
        return "ReadHoldingRegistersResponse{byteCount=" + this.byteCount + ", inputRegisters=" + registersStr + '}';
    }
}

