/*
 * Decompiled with CFR 0.152.
 */
package com.logistics.fisher.modbus.entity.func.request;

import com.logistics.fisher.modbus.entity.func.AbstractFunction;
import io.netty.buffer.ByteBuf;

public class WriteMultipleRegistersRequest
extends AbstractFunction {
    private short byteCount;
    private int[] registers;

    public WriteMultipleRegistersRequest() {
        super((short)16);
    }

    public WriteMultipleRegistersRequest(int startingAddress, int quantityOfRegisters, int[] registers) {
        super((short)16, startingAddress, quantityOfRegisters);
        if (registers.length > 125) {
            throw new IllegalArgumentException();
        }
        this.byteCount = (short)(registers.length * 2);
        this.registers = registers;
    }

    public short getByteCount() {
        return this.byteCount;
    }

    public int getQuantityOfRegisters() {
        return this.value;
    }

    public int getStartingAddress() {
        return this.address;
    }

    public int[] getRegisters() {
        return this.registers;
    }

    @Override
    public int calculateLength() {
        return super.calculateLength() + 1 + this.byteCount;
    }

    @Override
    public ByteBuf encode() {
        ByteBuf buf = super.encode();
        buf.writeByte((int)this.byteCount);
        for (int i = 0; i < this.registers.length; ++i) {
            buf.writeShort(this.registers[i]);
        }
        return buf;
    }

    @Override
    public void decode(ByteBuf data) {
        super.decode(data);
        this.byteCount = data.readUnsignedByte();
        this.registers = new int[this.byteCount / 2];
        for (int i = 0; i < this.registers.length; ++i) {
            this.registers[i] = data.readUnsignedShort();
        }
    }

    public String toString() {
        StringBuilder registersStr = new StringBuilder();
        registersStr.append("{");
        for (int i = 0; i < this.registers.length; ++i) {
            registersStr.append("register_");
            registersStr.append(i);
            registersStr.append("=");
            registersStr.append(this.registers[i]);
            registersStr.append(", ");
        }
        registersStr.delete(registersStr.length() - 2, registersStr.length());
        registersStr.append("}");
        return "WriteMultipleRegistersRequest{startingAddress=" + this.address + ", quantityOfRegisters=" + this.value + ", byteCount=" + this.byteCount + ", registers=" + registersStr + '}';
    }
}

