/*
 * Decompiled with CFR 0.152.
 */
package com.logistics.fisher.modbus.entity.func;

import com.logistics.fisher.modbus.entity.ModbusFunction;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;

public class ModbusError
extends ModbusFunction {
    private static final HashMap<Short, String> ERRORS = new HashMap();
    private short exceptionCode;
    private String exceptionMessage;

    public ModbusError(short functionCode) {
        super(functionCode);
    }

    public ModbusError(short functionCode, short exceptionCode) {
        super(functionCode);
        this.exceptionCode = exceptionCode;
    }

    private void setExceptionMessage(short exceptionCode) {
        this.exceptionMessage = ERRORS.get(exceptionCode) != null ? ERRORS.get(exceptionCode) : "UNDEFINED ERROR";
    }

    public short getExceptionCode() {
        return this.exceptionCode;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    @Override
    public int calculateLength() {
        return 2;
    }

    @Override
    public ByteBuf encode() {
        ByteBuf buf = Unpooled.buffer((int)this.calculateLength());
        buf.writeByte((int)this.getFunctionCode());
        buf.writeByte((int)this.exceptionCode);
        return buf;
    }

    @Override
    public void decode(ByteBuf data) {
        this.exceptionCode = data.readUnsignedByte();
        this.setExceptionMessage(this.exceptionCode);
    }

    public String toString() {
        return "ModbusError{exceptionCode=" + this.exceptionCode + ", exceptionMessage=" + this.exceptionMessage + '}';
    }

    static {
        ERRORS.put((short)1, "ILLEGAL FUNCTION");
        ERRORS.put((short)2, "ILLEGAL DATA ADDRESS");
        ERRORS.put((short)3, "ILLEGAL DATA VALUE");
        ERRORS.put((short)4, "SLAVE DEVICE FAILURE");
        ERRORS.put((short)5, "ACKNOWLEDGE");
        ERRORS.put((short)6, "SLAVE DEVICE BUSY");
        ERRORS.put((short)8, "MEMORY PARITY ERROR");
        ERRORS.put((short)10, "GATEWAY PATH UNAVAILABLE");
        ERRORS.put((short)11, "GATEWAY TARGET DEVICE FAILED TO RESPOND");
    }
}

