/*
 * Decompiled with CFR 0.152.
 */
package com.logistics.fisher.modbus;

import com.logistics.fisher.modbus.entity.exception.ConnectionException;
import com.logistics.fisher.modbus.handler.ModbusChannelInitializer;
import com.logistics.fisher.modbus.handler.ModbusRequestHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ModbusServer {
    public static final String PROP_CONNECTIONSTATE = "connectionState";
    private final int port;
    private ServerBootstrap bootstrap;
    private CONNECTION_STATES connectionState = CONNECTION_STATES.down;
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Channel parentChannel;
    private final ChannelGroup clientChannels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);

    public ModbusServer(int port) {
        this.port = port;
    }

    public void setup(ModbusRequestHandler handler) throws ConnectionException {
        handler.setServer(this);
        try {
            NioEventLoopGroup bossGroup = new NioEventLoopGroup();
            NioEventLoopGroup workerGroup = new NioEventLoopGroup();
            this.bootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)this.bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ModbusChannelInitializer(handler)).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            this.parentChannel = this.bootstrap.bind(this.port).sync().channel();
            this.setConnectionState(CONNECTION_STATES.listening);
            this.parentChannel.closeFuture().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>((EventLoopGroup)workerGroup, (EventLoopGroup)bossGroup){
                final /* synthetic */ EventLoopGroup val$workerGroup;
                final /* synthetic */ EventLoopGroup val$bossGroup;
                {
                    this.val$workerGroup = eventLoopGroup;
                    this.val$bossGroup = eventLoopGroup2;
                }

                public void operationComplete(ChannelFuture future) throws Exception {
                    this.val$workerGroup.shutdownGracefully();
                    this.val$bossGroup.shutdownGracefully();
                    ModbusServer.this.setConnectionState(CONNECTION_STATES.down);
                }
            });
        }
        catch (Exception ex) {
            this.setConnectionState(CONNECTION_STATES.down);
            Logger.getLogger(ModbusServer.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage());
            throw new ConnectionException(ex.getLocalizedMessage());
        }
    }

    public CONNECTION_STATES getConnectionState() {
        return this.connectionState;
    }

    public void setConnectionState(CONNECTION_STATES connectionState) {
        CONNECTION_STATES oldConnectionState = this.connectionState;
        this.connectionState = connectionState;
        this.propertyChangeSupport.firePropertyChange(PROP_CONNECTIONSTATE, (Object)oldConnectionState, (Object)connectionState);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void close() {
        if (this.parentChannel != null) {
            this.parentChannel.close().awaitUninterruptibly();
        }
        this.clientChannels.close().awaitUninterruptibly();
    }

    public ChannelGroup getClientChannels() {
        return this.clientChannels;
    }

    public void addClient(Channel channel) {
        this.clientChannels.add((Object)channel);
        this.setConnectionState(CONNECTION_STATES.clientsConnected);
    }

    public void removeClient(Channel channel) {
        this.clientChannels.remove((Object)channel);
        this.setConnectionState(CONNECTION_STATES.clientsConnected);
    }

    public static enum CONNECTION_STATES {
        listening,
        down,
        clientsConnected;

    }
}

