package com.logistics.fisher.modbus.handler;

import com.logistics.fisher.modbus.entity.ModbusFrame;
import com.logistics.fisher.modbus.entity.exception.ErrorResponseException;
import com.logistics.fisher.modbus.entity.exception.NoResponseException;
import com.logistics.fisher.modbus.entity.func.ModbusError;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/* loaded from: com_logistics_fisher_modbus_handler.jar:com/logistics/fisher/modbus/handler/ModbusResponseHandler.class */
public abstract class ModbusResponseHandler extends SimpleChannelInboundHandler<ModbusFrame> {
    private static final Logger logger = Logger.getLogger(ModbusResponseHandler.class.getSimpleName());
    private final Map<Integer, ModbusFrame> responses = new HashMap(100);

    public abstract void newResponse(ModbusFrame modbusFrame);

    public ModbusFrame getResponse(int transactionIdentifier) throws NoResponseException, ErrorResponseException {
        ModbusFrame frame;
        long timeoutTime = System.currentTimeMillis() + 2000;
        do {
            frame = this.responses.get(Integer.valueOf(transactionIdentifier));
            if (frame != null) {
                break;
            }
        } while (timeoutTime - System.currentTimeMillis() > 0);
        if (frame != null) {
            this.responses.remove(Integer.valueOf(transactionIdentifier));
        }
        if (frame == null) {
            throw new NoResponseException();
        }
        if (frame.getFunction() instanceof ModbusError) {
            throw new ErrorResponseException(frame.getFunction());
        }
        return frame;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.log(Level.SEVERE, cause.getLocalizedMessage());
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public void channelRead0(ChannelHandlerContext ctx, ModbusFrame response) throws Exception {
        this.responses.put(Integer.valueOf(response.getHeader().getTransactionIdentifier()), response);
        newResponse(response);
    }
}
