package com.logistics.fisher.modbus.handler;

import com.logistics.fisher.modbus.ModbusServer;
import com.logistics.fisher.modbus.entity.ModbusFrame;
import com.logistics.fisher.modbus.entity.ModbusFunction;
import com.logistics.fisher.modbus.entity.ModbusHeader;
import com.logistics.fisher.modbus.entity.func.WriteSingleCoil;
import com.logistics.fisher.modbus.entity.func.WriteSingleRegister;
import com.logistics.fisher.modbus.entity.func.request.ReadCoilsRequest;
import com.logistics.fisher.modbus.entity.func.request.ReadDiscreteInputsRequest;
import com.logistics.fisher.modbus.entity.func.request.ReadHoldingRegistersRequest;
import com.logistics.fisher.modbus.entity.func.request.ReadInputRegistersRequest;
import com.logistics.fisher.modbus.entity.func.request.WriteMultipleCoilsRequest;
import com.logistics.fisher.modbus.entity.func.request.WriteMultipleRegistersRequest;
import com.logistics.fisher.modbus.entity.func.response.ReadCoilsResponse;
import com.logistics.fisher.modbus.entity.func.response.ReadDiscreteInputsResponse;
import com.logistics.fisher.modbus.entity.func.response.ReadHoldingRegistersResponse;
import com.logistics.fisher.modbus.entity.func.response.ReadInputRegistersResponse;
import com.logistics.fisher.modbus.entity.func.response.WriteMultipleCoilsResponse;
import com.logistics.fisher.modbus.entity.func.response.WriteMultipleRegistersResponse;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

/* loaded from: com_logistics_fisher_modbus_handler.jar:com/logistics/fisher/modbus/handler/ModbusRequestHandler.class */
public abstract class ModbusRequestHandler extends SimpleChannelInboundHandler<ModbusFrame> {
    private static final Logger logger = Logger.getLogger(ModbusRequestHandler.class.getSimpleName());
    private ModbusServer server;

    protected abstract WriteSingleCoil writeSingleCoil(WriteSingleCoil writeSingleCoil);

    protected abstract WriteSingleRegister writeSingleRegister(WriteSingleRegister writeSingleRegister);

    protected abstract ReadCoilsResponse readCoilsRequest(ReadCoilsRequest readCoilsRequest);

    protected abstract ReadDiscreteInputsResponse readDiscreteInputsRequest(ReadDiscreteInputsRequest readDiscreteInputsRequest);

    protected abstract ReadInputRegistersResponse readInputRegistersRequest(ReadInputRegistersRequest readInputRegistersRequest);

    protected abstract ReadHoldingRegistersResponse readHoldingRegistersRequest(ReadHoldingRegistersRequest readHoldingRegistersRequest);

    protected abstract WriteMultipleRegistersResponse writeMultipleRegistersRequest(WriteMultipleRegistersRequest writeMultipleRegistersRequest);

    protected abstract WriteMultipleCoilsResponse writeMultipleCoilsRequest(WriteMultipleCoilsRequest writeMultipleCoilsRequest);

    public void setServer(ModbusServer server) {
        this.server = server;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.warning(cause.getLocalizedMessage());
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.server.removeClient(ctx.channel());
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.server.addClient(ctx.channel());
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public void channelRead0(ChannelHandlerContext ctx, ModbusFrame frame) throws Exception {
        WriteSingleCoil writeMultipleCoilsRequest;
        Channel channel = ctx.channel();
        ModbusFunction function = frame.getFunction();
        logger.log(Level.FINER, function.toString());
        if (function instanceof WriteSingleCoil) {
            WriteSingleCoil request = (WriteSingleCoil) function;
            writeMultipleCoilsRequest = writeSingleCoil(request);
        } else if (function instanceof WriteSingleRegister) {
            WriteSingleRegister request2 = (WriteSingleRegister) function;
            writeMultipleCoilsRequest = writeSingleRegister(request2);
        } else if (function instanceof ReadCoilsRequest) {
            ReadCoilsRequest request3 = (ReadCoilsRequest) function;
            writeMultipleCoilsRequest = readCoilsRequest(request3);
        } else if (function instanceof ReadDiscreteInputsRequest) {
            ReadDiscreteInputsRequest request4 = (ReadDiscreteInputsRequest) function;
            writeMultipleCoilsRequest = readDiscreteInputsRequest(request4);
        } else if (function instanceof ReadInputRegistersRequest) {
            ReadInputRegistersRequest request5 = (ReadInputRegistersRequest) function;
            writeMultipleCoilsRequest = readInputRegistersRequest(request5);
        } else if (function instanceof ReadHoldingRegistersRequest) {
            ReadHoldingRegistersRequest request6 = (ReadHoldingRegistersRequest) function;
            writeMultipleCoilsRequest = readHoldingRegistersRequest(request6);
        } else if (function instanceof WriteMultipleRegistersRequest) {
            WriteMultipleRegistersRequest request7 = (WriteMultipleRegistersRequest) function;
            writeMultipleCoilsRequest = writeMultipleRegistersRequest(request7);
        } else if (function instanceof WriteMultipleCoilsRequest) {
            WriteMultipleCoilsRequest request8 = (WriteMultipleCoilsRequest) function;
            writeMultipleCoilsRequest = writeMultipleCoilsRequest(request8);
        } else {
            throw new UnsupportedOperationException("Function not supported!");
        }
        ModbusHeader header = new ModbusHeader(frame.getHeader().getTransactionIdentifier(), frame.getHeader().getProtocolIdentifier(), writeMultipleCoilsRequest.calculateLength(), frame.getHeader().getUnitIdentifier());
        ModbusFrame responseFrame = new ModbusFrame(header, writeMultipleCoilsRequest);
        channel.write(responseFrame);
    }
}
