package com.logistics.fisher.modbus.handler;

import com.logistics.fisher.modbus.entity.ModbusFrame;
import com.logistics.fisher.modbus.entity.ModbusFunction;
import com.logistics.fisher.modbus.entity.ModbusHeader;
import com.logistics.fisher.modbus.entity.func.ModbusError;
import com.logistics.fisher.modbus.entity.func.WriteSingleCoil;
import com.logistics.fisher.modbus.entity.func.WriteSingleRegister;
import com.logistics.fisher.modbus.entity.func.request.ReadCoilsRequest;
import com.logistics.fisher.modbus.entity.func.request.ReadDiscreteInputsRequest;
import com.logistics.fisher.modbus.entity.func.request.ReadHoldingRegistersRequest;
import com.logistics.fisher.modbus.entity.func.request.ReadInputRegistersRequest;
import com.logistics.fisher.modbus.entity.func.request.WriteMultipleCoilsRequest;
import com.logistics.fisher.modbus.entity.func.request.WriteMultipleRegistersRequest;
import com.logistics.fisher.modbus.entity.func.response.ReadCoilsResponse;
import com.logistics.fisher.modbus.entity.func.response.ReadDiscreteInputsResponse;
import com.logistics.fisher.modbus.entity.func.response.ReadHoldingRegistersResponse;
import com.logistics.fisher.modbus.entity.func.response.ReadInputRegistersResponse;
import com.logistics.fisher.modbus.entity.func.response.WriteMultipleCoilsResponse;
import com.logistics.fisher.modbus.entity.func.response.WriteMultipleRegistersResponse;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;

/* loaded from: com_logistics_fisher_modbus_handler.jar:com/logistics/fisher/modbus/handler/ModbusDecoder.class */
public class ModbusDecoder extends ByteToMessageDecoder {
    private final boolean serverMode;

    public ModbusDecoder(boolean serverMode) {
        this.serverMode = serverMode;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) {
        if (buffer.capacity() < 8) {
            return;
        }
        ModbusHeader mbapHeader = ModbusHeader.decode(buffer);
        short functionCode = buffer.readUnsignedByte();
        ReadCoilsRequest readCoilsRequest = null;
        switch (functionCode) {
            case 1:
                if (this.serverMode) {
                    readCoilsRequest = new ReadCoilsRequest();
                    break;
                } else {
                    readCoilsRequest = new ReadCoilsResponse();
                    break;
                }
            case 2:
                if (this.serverMode) {
                    readCoilsRequest = new ReadDiscreteInputsRequest();
                    break;
                } else {
                    readCoilsRequest = new ReadDiscreteInputsResponse();
                    break;
                }
            case 3:
                if (this.serverMode) {
                    readCoilsRequest = new ReadHoldingRegistersRequest();
                    break;
                } else {
                    readCoilsRequest = new ReadHoldingRegistersResponse();
                    break;
                }
            case 4:
                if (this.serverMode) {
                    readCoilsRequest = new ReadInputRegistersRequest();
                    break;
                } else {
                    readCoilsRequest = new ReadInputRegistersResponse();
                    break;
                }
            case 5:
                readCoilsRequest = new WriteSingleCoil();
                break;
            case 6:
                readCoilsRequest = new WriteSingleRegister();
                break;
            case 15:
                if (this.serverMode) {
                    readCoilsRequest = new WriteMultipleCoilsRequest();
                    break;
                } else {
                    readCoilsRequest = new WriteMultipleCoilsResponse();
                    break;
                }
            case 16:
                if (this.serverMode) {
                    readCoilsRequest = new WriteMultipleRegistersRequest();
                    break;
                } else {
                    readCoilsRequest = new WriteMultipleRegistersResponse();
                    break;
                }
        }
        if (ModbusFunction.isError(functionCode)) {
            readCoilsRequest = new ModbusError(functionCode);
        } else if (readCoilsRequest == null) {
            readCoilsRequest = new ModbusError(functionCode, (short) 1);
        }
        readCoilsRequest.decode(buffer.readBytes(buffer.readableBytes()));
        ModbusFrame frame = new ModbusFrame(mbapHeader, readCoilsRequest);
        out.add(frame);
    }
}
