package com.logistics.fisher.modbus.handler;

import com.logistics.fisher.modbus.entity.ModbusFrame;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;

/* loaded from: com_logistics_fisher_modbus_handler.jar:com/logistics/fisher/modbus/handler/ModbusChannelInitializer.class */
public class ModbusChannelInitializer extends ChannelInitializer<SocketChannel> {
    private final SimpleChannelInboundHandler handler;

    public ModbusChannelInitializer(ModbusRequestHandler handler) {
        this.handler = handler;
    }

    public ModbusChannelInitializer(ModbusResponseHandler handler) {
        this.handler = handler;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("framer", new LengthFieldBasedFrameDecoder(260, 4, 2));
        pipeline.addLast("encoder", new ModbusEncoder());
        pipeline.addLast("decoder", new ModbusDecoder(this.handler instanceof ModbusRequestHandler));
        if (this.handler instanceof ModbusRequestHandler) {
            pipeline.addLast("requestHandler", this.handler);
        } else if (this.handler instanceof ModbusResponseHandler) {
            pipeline.addLast("responseHandler", this.handler);
        } else {
            pipeline.addLast("responseHandler", new ModbusResponseHandler() { // from class: com.logistics.fisher.modbus.handler.ModbusChannelInitializer.1
                @Override // com.logistics.fisher.modbus.handler.ModbusResponseHandler
                public void newResponse(ModbusFrame frame) {
                }
            });
        }
    }
}
