package com.logistics.fisher.modbus.example;

import com.logistics.fisher.modbus.ModbusServer;
import com.logistics.fisher.modbus.entity.exception.ConnectionException;
import java.util.logging.Level;
import java.util.logging.Logger;

/* loaded from: com_logistics_fisher_modbus_example.jar:com/logistics/fisher/modbus/example/ServerForWork.class */
public class ServerForWork {
    private final ModbusServer modbusServer = new ModbusServer(502);

    private ServerForWork() {
        try {
            this.modbusServer.setup(new ModbusRequestHandlerExample());
        } catch (ConnectionException e) {
            Logger.getLogger(ServerForWork.class.getName()).log(Level.SEVERE, (String) null, e);
        }
    }

    public ModbusServer getModbusServer() {
        return this.modbusServer;
    }

    public static ServerForWork getInstance() {
        return null;
    }

    /* loaded from: com_logistics_fisher_modbus_example.jar:com/logistics/fisher/modbus/example/ServerForWork$ServerForTestsHolder.class */
    private static class ServerForTestsHolder {
        private ServerForTestsHolder() {
        }
    }
}
