package com.logistics.fisher.modbus.example;

import com.logistics.fisher.modbus.ModbusClient;
import com.logistics.fisher.modbus.entity.exception.ConnectionException;
import com.logistics.fisher.modbus.entity.exception.ErrorResponseException;
import com.logistics.fisher.modbus.entity.exception.NoResponseException;
import com.logistics.fisher.modbus.entity.func.response.ReadHoldingRegistersResponse;
import java.util.logging.Level;
import java.util.logging.Logger;

/* loaded from: com_logistics_fisher_modbus_example.jar:com/logistics/fisher/modbus/example/Example.class */
public class Example {
    public static ModbusClient modbusClient;

    public static void main(String[] args) {
        PlcTask plcTask = new PlcTask();
        plcTask.start();
        try {
            Thread.sleep(5000L);
        } catch (Exception e) {
            e.printStackTrace();
        }
        while (true) {
            try {
                ReadHoldingRegistersResponse readHoldingRegisters = modbusClient.readHoldingRegisters(0, 10);
                System.out.println("readCoils=" + readHoldingRegisters);
                int[] registers = new int[10];
                registers[7] = 1;
                registers[8] = 1;
                modbusClient.writeMultipleRegisters(10, 10, registers);
                System.out.println("has_write++++");
                System.out.println(modbusClient.getChannel().isActive());
            } catch (NoResponseException | ErrorResponseException | ConnectionException e2) {
                Logger.getLogger(Example.class.getName()).log(Level.SEVERE, e2.getLocalizedMessage());
            }
            try {
                Thread.sleep(1000L);
            } catch (InterruptedException e3) {
                e3.printStackTrace();
            }
        }
    }
}
