package com.logistics.fisher.modbus.example;

import com.logistics.fisher.modbus.ModbusClient;
import com.logistics.fisher.modbus.entity.exception.ConnectionException;
import java.util.logging.Level;
import java.util.logging.Logger;

/* loaded from: com_logistics_fisher_modbus_example.jar:com/logistics/fisher/modbus/example/ClientForWork.class */
public class ClientForWork {
    private final ModbusClient modbusClient = new ModbusClient("192.168.10.101", 502);

    public ClientForWork(String host) {
        try {
            this.modbusClient.setup();
        } catch (ConnectionException e) {
            Logger.getLogger(ClientForWork.class.getName()).log(Level.SEVERE, (String) null, e);
        }
    }

    private ClientForWork() {
        try {
            this.modbusClient.setup();
        } catch (ConnectionException e) {
            Logger.getLogger(ClientForWork.class.getName()).log(Level.SEVERE, (String) null, e);
        }
    }

    public ModbusClient getModbusClient() {
        return this.modbusClient;
    }

    public static ClientForWork getInstance() {
        return null;
    }

    /* loaded from: com_logistics_fisher_modbus_example.jar:com/logistics/fisher/modbus/example/ClientForWork$ClientAndServerHolder.class */
    private static class ClientAndServerHolder {
        private ClientAndServerHolder() {
        }
    }

    public static void main(String[] args) {
        ModbusClient modbusClient = new ModbusClient("127.0.0.1", 502);
        try {
            modbusClient.setup();
        } catch (ConnectionException ex) {
            ex.printStackTrace();
        }
    }
}
