package com.logistics.fisher.modbus.entity.func.response;

import com.logistics.fisher.modbus.entity.ModbusFunction;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.BitSet;

/* loaded from: com_logistics_fisher_modbus_entity_func_response.jar:com/logistics/fisher/modbus/entity/func/response/ReadDiscreteInputsResponse.class */
public class ReadDiscreteInputsResponse extends ModbusFunction {
    private short byteCount;
    private BitSet inputStatus;

    public ReadDiscreteInputsResponse() {
        super((short) 2);
    }

    public ReadDiscreteInputsResponse(BitSet inputStatus) {
        super((short) 2);
        byte[] inputs = inputStatus.toByteArray();
        if (inputs.length > 250) {
            throw new IllegalArgumentException();
        }
        this.byteCount = (short) inputs.length;
        this.inputStatus = inputStatus;
    }

    public BitSet getInputStatus() {
        return this.inputStatus;
    }

    public short getByteCount() {
        return this.byteCount;
    }

    public int calculateLength() {
        return 2 + this.byteCount;
    }

    public ByteBuf encode() {
        ByteBuf buf = Unpooled.buffer(calculateLength());
        buf.writeByte(getFunctionCode());
        buf.writeByte(this.byteCount);
        buf.writeBytes(this.inputStatus.toByteArray());
        return buf;
    }

    public void decode(ByteBuf data) {
        this.byteCount = data.readUnsignedByte();
        byte[] inputs = new byte[this.byteCount];
        data.readBytes(inputs);
        this.inputStatus = BitSet.valueOf(inputs);
    }

    public String toString() {
        return "ReadDiscreteInputsResponse{byteCount=" + ((int) this.byteCount) + ", coilStatus=" + this.inputStatus + '}';
    }
}
