package com.logistics.fisher.modbus.entity.func.request;

import com.logistics.fisher.modbus.entity.func.AbstractFunction;
import io.netty.buffer.ByteBuf;
import java.util.BitSet;

/* loaded from: com_logistics_fisher_modbus_entity_func_request.jar:com/logistics/fisher/modbus/entity/func/request/WriteMultipleCoilsRequest.class */
public class WriteMultipleCoilsRequest extends AbstractFunction {
    private short byteCount;
    private BitSet outputsValue;

    public WriteMultipleCoilsRequest() {
        super((short) 15);
    }

    public WriteMultipleCoilsRequest(int startingAddress, int quantityOfOutputs, BitSet outputsValue) {
        super((short) 15, startingAddress, quantityOfOutputs);
        byte[] coils = outputsValue.toByteArray();
        if (coils.length > 246) {
            throw new IllegalArgumentException();
        }
        this.byteCount = (short) coils.length;
        this.outputsValue = outputsValue;
    }

    public short getByteCount() {
        return this.byteCount;
    }

    public BitSet getOutputsValue() {
        return this.outputsValue;
    }

    public int getQuantityOfOutputs() {
        return this.value;
    }

    public int getStartingAddress() {
        return this.address;
    }

    public int calculateLength() {
        return super.calculateLength() + 1 + this.byteCount;
    }

    public ByteBuf encode() {
        ByteBuf buf = super.encode();
        buf.writeByte(this.byteCount);
        buf.writeBytes(this.outputsValue.toByteArray());
        return buf;
    }

    public void decode(ByteBuf data) {
        super.decode(data);
        this.byteCount = data.readUnsignedByte();
        byte[] coils = new byte[this.byteCount];
        data.readBytes(coils);
        this.outputsValue = BitSet.valueOf(coils);
    }

    public String toString() {
        return "WriteMultipleCoilsRequest{startingAddress=" + this.address + ", quantityOfOutputs=" + this.value + ", byteCount=" + ((int) this.byteCount) + ", outputsValue=" + this.outputsValue + '}';
    }
}
