package com.logistics.fisher.modbus.entity;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

/* loaded from: com_logistics_fisher_modbus_entity.jar:com/logistics/fisher/modbus/entity/ModbusHeader.class */
public class ModbusHeader {
    private final int transactionIdentifier;
    private final int protocolIdentifier;
    private final int length;
    private final short unitIdentifier;

    public ModbusHeader(int transactionIdentifier, int protocolIdentifier, int pduLength, short unitIdentifier) {
        this.transactionIdentifier = transactionIdentifier;
        this.protocolIdentifier = protocolIdentifier;
        this.length = pduLength + 1;
        this.unitIdentifier = unitIdentifier;
    }

    public int getLength() {
        return this.length;
    }

    public int getProtocolIdentifier() {
        return this.protocolIdentifier;
    }

    public int getTransactionIdentifier() {
        return this.transactionIdentifier;
    }

    public short getUnitIdentifier() {
        return this.unitIdentifier;
    }

    public static ModbusHeader decode(ByteBuf buffer) {
        return new ModbusHeader(buffer.readUnsignedShort(), buffer.readUnsignedShort(), buffer.readUnsignedShort(), buffer.readUnsignedByte());
    }

    public ByteBuf encode() {
        ByteBuf buf = Unpooled.buffer();
        buf.writeShort(this.transactionIdentifier);
        buf.writeShort(this.protocolIdentifier);
        buf.writeShort(this.length);
        buf.writeByte(this.unitIdentifier);
        return buf;
    }

    public String toString() {
        return "ModbusHeader{transactionIdentifier=" + this.transactionIdentifier + ", protocolIdentifier=" + this.protocolIdentifier + ", length=" + this.length + ", unitIdentifier=" + ((int) this.unitIdentifier) + '}';
    }
}
