package com.logistics.fisher.modbus.entity;

import io.netty.buffer.ByteBuf;

/* loaded from: com_logistics_fisher_modbus_entity.jar:com/logistics/fisher/modbus/entity/ModbusFunction.class */
public abstract class ModbusFunction {
    public static final short READ_COILS = 1;
    public static final short READ_DISCRETE_INPUTS = 2;
    public static final short READ_HOLDING_REGISTERS = 3;
    public static final short READ_INPUT_REGISTERS = 4;
    public static final short WRITE_SINGLE_COIL = 5;
    public static final short WRITE_SINGLE_REGISTER = 6;
    public static final short WRITE_MULTIPLE_COILS = 15;
    public static final short WRITE_MULTIPLE_REGISTERS = 16;
    public static final short READ_FILE_RECORD = 20;
    public static final short WRITE_FILE_RECORD = 21;
    public static final short MASK_WRITE_REGISTER = 22;
    public static final short READ_WRITE_MULTIPLE_REGISTERS = 23;
    public static final short READ_FIFO_QUEUE = 24;
    public static final short ENCAPSULATED_INTERFACE_TRANSPORT = 43;
    private final short functionCode;

    public abstract int calculateLength();

    public abstract ByteBuf encode();

    public abstract void decode(ByteBuf byteBuf);

    public ModbusFunction(short functionCode) {
        this.functionCode = functionCode;
    }

    public short getFunctionCode() {
        return this.functionCode;
    }

    public static boolean isError(short functionCode) {
        return functionCode - 128 >= 0;
    }
}
