package com.logistics.fisher.modbus.entity;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

/* loaded from: com_logistics_fisher_modbus_entity.jar:com/logistics/fisher/modbus/entity/ModbusFrame.class */
public class ModbusFrame {
    private final ModbusHeader header;
    private final ModbusFunction function;

    public ModbusFrame(ModbusHeader header, ModbusFunction function) {
        this.header = header;
        this.function = function;
    }

    public ModbusHeader getHeader() {
        return this.header;
    }

    public ModbusFunction getFunction() {
        return this.function;
    }

    public ByteBuf encode() {
        ByteBuf buf = Unpooled.buffer();
        buf.writeBytes(this.header.encode());
        buf.writeBytes(this.function.encode());
        return buf;
    }

    public String toString() {
        return "ModbusFrame{header=" + this.header + ", function=" + this.function + '}';
    }
}
