package com.logistics.fisher.modbus.handler;

import com.logistics.fisher.modbus.entity.ModbusFrame;
import com.logistics.fisher.modbus.entity.exception.ErrorResponseException;
import com.logistics.fisher.modbus.entity.exception.NoResponseException;
import com.logistics.fisher.modbus.entity.func.ModbusError;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ModbusResponseHandler extends SimpleChannelInboundHandler {

   private static final Logger logger = Logger.getLogger(ModbusResponseHandler.class.getSimpleName());
   private final Map responses = new HashMap(100);


   public ModbusFrame getResponse(int transactionIdentifier) throws NoResponseException, ErrorResponseException {
      long timeoutTime = System.currentTimeMillis() + 2000L;

      ModbusFrame frame;
      do {
         frame = (ModbusFrame)this.responses.get(Integer.valueOf(transactionIdentifier));
      } while(frame == null && timeoutTime - System.currentTimeMillis() > 0L);

      if(frame != null) {
         this.responses.remove(Integer.valueOf(transactionIdentifier));
      }

      if(frame == null) {
         throw new NoResponseException();
      } else if(frame.getFunction() instanceof ModbusError) {
         throw new ErrorResponseException((ModbusError)frame.getFunction());
      } else {
         return frame;
      }
   }

   public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
      logger.log(Level.SEVERE, cause.getLocalizedMessage());
   }

   protected void channelRead0(ChannelHandlerContext ctx, ModbusFrame response) throws Exception {
      this.responses.put(Integer.valueOf(response.getHeader().getTransactionIdentifier()), response);
      this.newResponse(response);
   }

   public abstract void newResponse(ModbusFrame var1);

}
