package com.logistics.fisher.modbus.handler;

import com.logistics.fisher.modbus.ModbusServer;
import com.logistics.fisher.modbus.entity.ModbusFrame;
import com.logistics.fisher.modbus.entity.ModbusFunction;
import com.logistics.fisher.modbus.entity.ModbusHeader;
import com.logistics.fisher.modbus.entity.func.WriteSingleCoil;
import com.logistics.fisher.modbus.entity.func.WriteSingleRegister;
import com.logistics.fisher.modbus.entity.func.request.ReadCoilsRequest;
import com.logistics.fisher.modbus.entity.func.request.ReadDiscreteInputsRequest;
import com.logistics.fisher.modbus.entity.func.request.ReadHoldingRegistersRequest;
import com.logistics.fisher.modbus.entity.func.request.ReadInputRegistersRequest;
import com.logistics.fisher.modbus.entity.func.request.WriteMultipleCoilsRequest;
import com.logistics.fisher.modbus.entity.func.request.WriteMultipleRegistersRequest;
import com.logistics.fisher.modbus.entity.func.response.ReadCoilsResponse;
import com.logistics.fisher.modbus.entity.func.response.ReadDiscreteInputsResponse;
import com.logistics.fisher.modbus.entity.func.response.ReadHoldingRegistersResponse;
import com.logistics.fisher.modbus.entity.func.response.ReadInputRegistersResponse;
import com.logistics.fisher.modbus.entity.func.response.WriteMultipleCoilsResponse;
import com.logistics.fisher.modbus.entity.func.response.WriteMultipleRegistersResponse;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ModbusRequestHandler extends SimpleChannelInboundHandler {

   private static final Logger logger = Logger.getLogger(ModbusRequestHandler.class.getSimpleName());
   private ModbusServer server;


   public void setServer(ModbusServer server) {
      this.server = server;
   }

   public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
      logger.warning(cause.getLocalizedMessage());
   }

   public void channelInactive(ChannelHandlerContext ctx) throws Exception {
      this.server.removeClient(ctx.channel());
   }

   public void channelActive(ChannelHandlerContext ctx) throws Exception {
      this.server.addClient(ctx.channel());
   }

   protected void channelRead0(ChannelHandlerContext ctx, ModbusFrame frame) throws Exception {
      Channel channel = ctx.channel();
      ModbusFunction function = frame.getFunction();
      logger.log(Level.FINER, function.toString());
      Object response;
      if(function instanceof WriteSingleCoil) {
         WriteSingleCoil header = (WriteSingleCoil)function;
         response = this.writeSingleCoil(header);
      } else if(function instanceof WriteSingleRegister) {
         WriteSingleRegister header1 = (WriteSingleRegister)function;
         response = this.writeSingleRegister(header1);
      } else if(function instanceof ReadCoilsRequest) {
         ReadCoilsRequest header2 = (ReadCoilsRequest)function;
         response = this.readCoilsRequest(header2);
      } else if(function instanceof ReadDiscreteInputsRequest) {
         ReadDiscreteInputsRequest header3 = (ReadDiscreteInputsRequest)function;
         response = this.readDiscreteInputsRequest(header3);
      } else if(function instanceof ReadInputRegistersRequest) {
         ReadInputRegistersRequest header4 = (ReadInputRegistersRequest)function;
         response = this.readInputRegistersRequest(header4);
      } else if(function instanceof ReadHoldingRegistersRequest) {
         ReadHoldingRegistersRequest header5 = (ReadHoldingRegistersRequest)function;
         response = this.readHoldingRegistersRequest(header5);
      } else if(function instanceof WriteMultipleRegistersRequest) {
         WriteMultipleRegistersRequest header6 = (WriteMultipleRegistersRequest)function;
         response = this.writeMultipleRegistersRequest(header6);
      } else {
         if(!(function instanceof WriteMultipleCoilsRequest)) {
            throw new UnsupportedOperationException("Function not supported!");
         }

         WriteMultipleCoilsRequest header7 = (WriteMultipleCoilsRequest)function;
         response = this.writeMultipleCoilsRequest(header7);
      }

      ModbusHeader header8 = new ModbusHeader(frame.getHeader().getTransactionIdentifier(), frame.getHeader().getProtocolIdentifier(), ((ModbusFunction)response).calculateLength(), frame.getHeader().getUnitIdentifier());
      ModbusFrame responseFrame = new ModbusFrame(header8, (ModbusFunction)response);
      channel.write(responseFrame);
   }

   protected abstract WriteSingleCoil writeSingleCoil(WriteSingleCoil var1);

   protected abstract WriteSingleRegister writeSingleRegister(WriteSingleRegister var1);

   protected abstract ReadCoilsResponse readCoilsRequest(ReadCoilsRequest var1);

   protected abstract ReadDiscreteInputsResponse readDiscreteInputsRequest(ReadDiscreteInputsRequest var1);

   protected abstract ReadInputRegistersResponse readInputRegistersRequest(ReadInputRegistersRequest var1);

   protected abstract ReadHoldingRegistersResponse readHoldingRegistersRequest(ReadHoldingRegistersRequest var1);

   protected abstract WriteMultipleRegistersResponse writeMultipleRegistersRequest(WriteMultipleRegistersRequest var1);

   protected abstract WriteMultipleCoilsResponse writeMultipleCoilsRequest(WriteMultipleCoilsRequest var1);

}
