package com.logistics.fisher.modbus.handler;

import com.logistics.fisher.modbus.entity.ModbusFrame;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;

public class ModbusEncoder extends ChannelOutboundHandlerAdapter {

   public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
      if(msg instanceof ModbusFrame) {
         ModbusFrame frame = (ModbusFrame)msg;
         ctx.writeAndFlush(frame.encode());
      } else {
         ctx.write(msg);
      }

   }
}
