package com.logistics.fisher.modbus.handler;

import com.logistics.fisher.modbus.entity.ModbusFrame;
import com.logistics.fisher.modbus.entity.ModbusFunction;
import com.logistics.fisher.modbus.entity.ModbusHeader;
import com.logistics.fisher.modbus.entity.func.ModbusError;
import com.logistics.fisher.modbus.entity.func.WriteSingleCoil;
import com.logistics.fisher.modbus.entity.func.WriteSingleRegister;
import com.logistics.fisher.modbus.entity.func.request.ReadCoilsRequest;
import com.logistics.fisher.modbus.entity.func.request.ReadDiscreteInputsRequest;
import com.logistics.fisher.modbus.entity.func.request.ReadHoldingRegistersRequest;
import com.logistics.fisher.modbus.entity.func.request.ReadInputRegistersRequest;
import com.logistics.fisher.modbus.entity.func.request.WriteMultipleCoilsRequest;
import com.logistics.fisher.modbus.entity.func.request.WriteMultipleRegistersRequest;
import com.logistics.fisher.modbus.entity.func.response.ReadCoilsResponse;
import com.logistics.fisher.modbus.entity.func.response.ReadDiscreteInputsResponse;
import com.logistics.fisher.modbus.entity.func.response.ReadHoldingRegistersResponse;
import com.logistics.fisher.modbus.entity.func.response.ReadInputRegistersResponse;
import com.logistics.fisher.modbus.entity.func.response.WriteMultipleCoilsResponse;
import com.logistics.fisher.modbus.entity.func.response.WriteMultipleRegistersResponse;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;

public class ModbusDecoder extends ByteToMessageDecoder {

   private final boolean serverMode;


   public ModbusDecoder(boolean serverMode) {
      this.serverMode = serverMode;
   }

   protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List out) {
      if(buffer.capacity() >= 8) {
         ModbusHeader mbapHeader = ModbusHeader.decode(buffer);
         short functionCode = buffer.readUnsignedByte();
         Object function = null;
         switch(functionCode) {
         case 1:
            if(this.serverMode) {
               function = new ReadCoilsRequest();
            } else {
               function = new ReadCoilsResponse();
            }
            break;
         case 2:
            if(this.serverMode) {
               function = new ReadDiscreteInputsRequest();
            } else {
               function = new ReadDiscreteInputsResponse();
            }
            break;
         case 3:
            if(this.serverMode) {
               function = new ReadHoldingRegistersRequest();
            } else {
               function = new ReadHoldingRegistersResponse();
            }
            break;
         case 4:
            if(this.serverMode) {
               function = new ReadInputRegistersRequest();
            } else {
               function = new ReadInputRegistersResponse();
            }
            break;
         case 5:
            function = new WriteSingleCoil();
            break;
         case 6:
            function = new WriteSingleRegister();
         case 7:
         case 8:
         case 9:
         case 10:
         case 11:
         case 12:
         case 13:
         case 14:
         default:
            break;
         case 15:
            if(this.serverMode) {
               function = new WriteMultipleCoilsRequest();
            } else {
               function = new WriteMultipleCoilsResponse();
            }
            break;
         case 16:
            if(this.serverMode) {
               function = new WriteMultipleRegistersRequest();
            } else {
               function = new WriteMultipleRegistersResponse();
            }
         }

         if(ModbusFunction.isError(functionCode)) {
            function = new ModbusError(functionCode);
         } else if(function == null) {
            function = new ModbusError(functionCode, (short)1);
         }

         ((ModbusFunction)function).decode(buffer.readBytes(buffer.readableBytes()));
         ModbusFrame frame = new ModbusFrame(mbapHeader, (ModbusFunction)function);
         out.add(frame);
      }
   }
}
