package com.logistics.fisher.modbus.example;

import com.logistics.fisher.modbus.entity.func.WriteSingleCoil;
import com.logistics.fisher.modbus.entity.func.WriteSingleRegister;
import com.logistics.fisher.modbus.entity.func.request.ReadCoilsRequest;
import com.logistics.fisher.modbus.entity.func.request.ReadDiscreteInputsRequest;
import com.logistics.fisher.modbus.entity.func.request.ReadHoldingRegistersRequest;
import com.logistics.fisher.modbus.entity.func.request.ReadInputRegistersRequest;
import com.logistics.fisher.modbus.entity.func.request.WriteMultipleCoilsRequest;
import com.logistics.fisher.modbus.entity.func.request.WriteMultipleRegistersRequest;
import com.logistics.fisher.modbus.entity.func.response.ReadCoilsResponse;
import com.logistics.fisher.modbus.entity.func.response.ReadDiscreteInputsResponse;
import com.logistics.fisher.modbus.entity.func.response.ReadHoldingRegistersResponse;
import com.logistics.fisher.modbus.entity.func.response.ReadInputRegistersResponse;
import com.logistics.fisher.modbus.entity.func.response.WriteMultipleCoilsResponse;
import com.logistics.fisher.modbus.entity.func.response.WriteMultipleRegistersResponse;
import com.logistics.fisher.modbus.handler.ModbusRequestHandler;
import java.util.BitSet;

public class ModbusRequestHandlerExample extends ModbusRequestHandler {

   protected WriteSingleCoil writeSingleCoil(WriteSingleCoil request) {
      return request;
   }

   protected WriteSingleRegister writeSingleRegister(WriteSingleRegister request) {
      return request;
   }

   protected ReadCoilsResponse readCoilsRequest(ReadCoilsRequest request) {
      BitSet coils = new BitSet(request.getQuantityOfCoils());
      coils.set(0);
      coils.set(5);
      coils.set(8);
      return new ReadCoilsResponse(coils);
   }

   protected ReadDiscreteInputsResponse readDiscreteInputsRequest(ReadDiscreteInputsRequest request) {
      BitSet coils = new BitSet(request.getQuantityOfCoils());
      coils.set(0);
      coils.set(5);
      coils.set(8);
      return new ReadDiscreteInputsResponse(coils);
   }

   protected ReadInputRegistersResponse readInputRegistersRequest(ReadInputRegistersRequest request) {
      int[] registers = new int[request.getQuantityOfInputRegisters()];
      registers[0] = '\uffff';
      registers[1] = '\uf0f0';
      registers[2] = 3855;
      return new ReadInputRegistersResponse(registers);
   }

   protected ReadHoldingRegistersResponse readHoldingRegistersRequest(ReadHoldingRegistersRequest request) {
      int[] registers = new int[request.getQuantityOfInputRegisters()];
      registers[0] = '\uffff';
      registers[1] = '\uf0f0';
      registers[2] = 3855;
      return new ReadHoldingRegistersResponse(registers);
   }

   protected WriteMultipleRegistersResponse writeMultipleRegistersRequest(WriteMultipleRegistersRequest request) {
      return new WriteMultipleRegistersResponse(request.getStartingAddress(), request.getQuantityOfRegisters());
   }

   protected WriteMultipleCoilsResponse writeMultipleCoilsRequest(WriteMultipleCoilsRequest request) {
      return new WriteMultipleCoilsResponse(request.getStartingAddress(), request.getQuantityOfOutputs());
   }
}
