package com.logistics.fisher.modbus.example;

import com.logistics.fisher.modbus.ModbusClient;
import com.logistics.fisher.modbus.entity.exception.ConnectionException;
import com.logistics.fisher.modbus.entity.exception.ErrorResponseException;
import com.logistics.fisher.modbus.entity.exception.NoResponseException;
import com.logistics.fisher.modbus.entity.func.response.ReadHoldingRegistersResponse;
import com.logistics.fisher.modbus.example.PlcTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Example {

   public static ModbusClient modbusClient;


   public static void main(String[] args) {
      PlcTask plcTask = new PlcTask();
      plcTask.start();

      try {
         Thread.sleep(5000L);
      } catch (Exception var6) {
         var6.printStackTrace();
      }

      ReadHoldingRegistersResponse readHoldingRegisters = null;

      while(true) {
         try {
            readHoldingRegisters = modbusClient.readHoldingRegisters(0, 10);
            System.out.println("readCoils=" + readHoldingRegisters);
            int[] e = new int[10];
            e[7] = 1;
            e[8] = 1;
            modbusClient.writeMultipleRegisters(10, 10, e);
            System.out.println("has_write++++");
            System.out.println(modbusClient.getChannel().isActive());
         } catch (ErrorResponseException | ConnectionException | NoResponseException var5) {
            Logger.getLogger(Example.class.getName()).log(Level.SEVERE, var5.getLocalizedMessage());
         }

         try {
            Thread.sleep(1000L);
         } catch (InterruptedException var4) {
            var4.printStackTrace();
         }
      }
   }
}
