package com.logistics.fisher.modbus.entity.func;

import com.logistics.fisher.modbus.entity.func.AbstractFunction;
import io.netty.buffer.ByteBuf;

public class WriteSingleCoil extends AbstractFunction {

   private boolean state;


   public WriteSingleCoil() {
      super((short)5);
   }

   public WriteSingleCoil(int outputAddress, boolean state) {
      super((short)5, outputAddress, state?'\uff00':0);
      this.state = state;
   }

   public int getOutputAddress() {
      return this.address;
   }

   public void decode(ByteBuf data) {
      super.decode(data);
      this.state = this.value == '\uff00';
   }

   public boolean isState() {
      return this.state;
   }

   public String toString() {
      return "WriteSingleCoil{outputAddress=" + this.address + ", state=" + this.state + '}';
   }
}
