package com.logistics.fisher.modbus.entity.func;

import com.logistics.fisher.modbus.entity.ModbusFunction;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;

public class ModbusError extends ModbusFunction {

   private static final HashMap ERRORS = new HashMap();
   private short exceptionCode;
   private String exceptionMessage;


   public ModbusError(short functionCode) {
      super(functionCode);
   }

   public ModbusError(short functionCode, short exceptionCode) {
      super(functionCode);
      this.exceptionCode = exceptionCode;
   }

   private void setExceptionMessage(short exceptionCode) {
      this.exceptionMessage = ERRORS.get(Short.valueOf(exceptionCode)) != null?(String)ERRORS.get(Short.valueOf(exceptionCode)):"UNDEFINED ERROR";
   }

   public short getExceptionCode() {
      return this.exceptionCode;
   }

   public String getExceptionMessage() {
      return this.exceptionMessage;
   }

   public int calculateLength() {
      return 2;
   }

   public ByteBuf encode() {
      ByteBuf buf = Unpooled.buffer(this.calculateLength());
      buf.writeByte(this.getFunctionCode());
      buf.writeByte(this.exceptionCode);
      return buf;
   }

   public void decode(ByteBuf data) {
      this.exceptionCode = data.readUnsignedByte();
      this.setExceptionMessage(this.exceptionCode);
   }

   public String toString() {
      return "ModbusError{exceptionCode=" + this.exceptionCode + ", exceptionMessage=" + this.exceptionMessage + '}';
   }

   static {
      ERRORS.put(Short.valueOf((short)1), "ILLEGAL FUNCTION");
      ERRORS.put(Short.valueOf((short)2), "ILLEGAL DATA ADDRESS");
      ERRORS.put(Short.valueOf((short)3), "ILLEGAL DATA VALUE");
      ERRORS.put(Short.valueOf((short)4), "SLAVE DEVICE FAILURE");
      ERRORS.put(Short.valueOf((short)5), "ACKNOWLEDGE");
      ERRORS.put(Short.valueOf((short)6), "SLAVE DEVICE BUSY");
      ERRORS.put(Short.valueOf((short)8), "MEMORY PARITY ERROR");
      ERRORS.put(Short.valueOf((short)10), "GATEWAY PATH UNAVAILABLE");
      ERRORS.put(Short.valueOf((short)11), "GATEWAY TARGET DEVICE FAILED TO RESPOND");
   }
}
