/*
 * Decompiled with CFR 0.152.
 */
package net.m3tte.tactical_imbuements.procedures;

import java.util.LinkedList;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.m3tte.tactical_imbuements.definitions.ImbuementDefinitions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@Mod.EventBusSubscriber
public class TickProcedure {
    public static int defaultMaxTime = 600;

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        LivingEntity living = event.getEntity();
        TickProcedure.execute((Event)event, (LevelAccessor)living.m_9236_(), living.m_20185_(), living.m_20186_(), living.m_20189_(), (Entity)living);
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        TickProcedure.execute(null, world, x, y, z, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            System.out.println(entity.getClass());
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        TickProcedure.oncePerHand(hand -> {
            ItemStack handItem = living.m_21120_(hand);
            if (!handItem.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("tactical_imbuements:applicable")))) {
                return;
            }
            double timeout = 0.0;
            Entity clplayer = entity;
            if ((timeout += handItem.m_41784_().m_128459_("imbueCounter") - (double)clplayer.f_19797_) > (double)(defaultMaxTime + 60) && !world.m_5776_()) {
                TickProcedure.clearImbuement(living, hand);
            }
            if (handItem.m_41783_() == null) {
                return;
            }
            String imbueType = handItem.m_41783_().m_128461_("imbueType");
            if (timeout > 1.0 && timeout < (double)(defaultMaxTime + 60)) {
                if (imbueType.length() > 2) {
                    TickProcedure.particleImbueEffectCheck(living, hand, imbueType);
                }
            } else if ((timeout > 0.0 || imbueType.length() > 2) && !world.m_5776_()) {
                TickProcedure.clearImbuement(living, hand);
            }
        });
    }

    private static void oncePerHand(Consumer<InteractionHand> c) {
        c.accept(InteractionHand.MAIN_HAND);
        c.accept(InteractionHand.OFF_HAND);
    }

    private static void clearImbuement(LivingEntity entity, InteractionHand hand) {
        System.out.println("Clearing imbuement on, clientside?" + entity.m_9236_().m_5776_());
        ItemStack item = entity.m_21120_(hand);
        item.m_41749_("imbueCounter");
        item.m_41749_("maxImbueTime");
        item.m_41749_("imbueType");
    }

    private static LinkedList<Vec3> offsetCalculator(ItemStack item) {
        int length = 3;
        if (item.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("tactical_imbuements:length_medium")))) {
            length = 4;
        }
        if (item.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("tactical_imbuements:length_long")))) {
            length = 5;
        }
        LinkedList<Vec3> offsets = new LinkedList<Vec3>();
        for (int i = 1; i < length + 1; ++i) {
            offsets.add(new Vec3(0.0, -0.02 * (double)i, -0.3 * (double)i));
        }
        return offsets;
    }

    private static void doArmatureParticle(Joint j, LivingEntityPatch<?> entityPatch, SimpleParticleType particle, float amount, Vec3 particleSpeed, LinkedList<Vec3> offsets) {
        Level l = ((LivingEntity)entityPatch.getOriginal()).m_9236_();
        RandomSource r = l.f_46441_;
        for (float i = 1.0f; i <= 9.0f; i += 2.0f) {
            Pose middlePose = entityPatch.getAnimator().getPose((i + (float)r.m_188503_(3) - 1.0f) / 10.0f);
            Vec3 posMid = ((LivingEntity)entityPatch.getOriginal()).m_20318_((i + (float)r.m_188503_(3) - 1.0f) / 10.0f);
            OpenMatrix4f middleModelTf = OpenMatrix4f.createTranslation((float)((float)posMid.f_82479_), (float)((float)posMid.f_82480_), (float)((float)posMid.f_82481_)).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(entityPatch.getModelMatrix((i + (float)r.m_188503_(3) - 1.0f) / 10.0f)));
            OpenMatrix4f middleJointTf = entityPatch.getArmature().getBindedTransformFor(middlePose, j).mulFront(middleModelTf);
            for (Vec3 modifier : offsets) {
                if (r.m_188503_((int)(100.0f / amount)) >= 40) continue;
                modifier = modifier.m_82520_((double)(r.m_188501_() * 0.2f) - 0.1, (double)(r.m_188501_() * 0.2f) - 0.1, (double)(r.m_188501_() * 0.2f) - 0.1);
                Vec3 particlePos = OpenMatrix4f.transform((OpenMatrix4f)middleJointTf, (Vec3)modifier);
                l.m_7106_((ParticleOptions)particle, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, particleSpeed.f_82479_, particleSpeed.f_82480_, particleSpeed.f_82481_);
            }
        }
    }

    private static void particleImbueEffectCheck(LivingEntity entity, InteractionHand hand, String imbueType) {
        LivingEntityPatch entitypatch = (LivingEntityPatch)entity.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, null).orElse(null);
        if (entitypatch == null) {
            return;
        }
        if (entitypatch.getValidItemInHand(hand) == null) {
            return;
        }
        Joint toolL = entitypatch.getArmature().searchJointByName("Tool_L");
        Joint toolR = entitypatch.getArmature().searchJointByName("Tool_R");
        if (hand == InteractionHand.MAIN_HAND) {
            if (toolR != null && imbueType.length() > 2) {
                TickProcedure.doArmatureParticle(toolR, entitypatch, TickProcedure.trailParticleGetter(imbueType), TickProcedure.particleAmount(imbueType), TickProcedure.particleSpeed(imbueType), TickProcedure.offsetCalculator(entity.m_21120_(hand)));
            }
        } else if (toolL != null && imbueType.length() > 2) {
            TickProcedure.doArmatureParticle(toolL, entitypatch, TickProcedure.trailParticleGetter(imbueType), TickProcedure.particleAmount(imbueType), TickProcedure.particleSpeed(imbueType), TickProcedure.offsetCalculator(entity.m_21120_(hand)));
        }
    }

    private static SimpleParticleType trailParticleGetter(String type) {
        switch (type) {
            case "flame": {
                return ImbuementDefinitions.FLAME.getEmitParticle();
            }
            case "venom": {
                return ImbuementDefinitions.VENOM.getEmitParticle();
            }
            case "spark": {
                return ImbuementDefinitions.SPARK.getEmitParticle();
            }
            case "freeze": {
                return ImbuementDefinitions.FREEZE.getEmitParticle();
            }
        }
        return null;
    }

    private static Vec3 particleSpeed(String type) {
        Random r = new Random();
        switch (type) {
            case "spark": {
                return new Vec3(0.02 * (double)TickProcedure.inverter(r), 0.02 * (double)TickProcedure.inverter(r), 0.02 * (double)TickProcedure.inverter(r));
            }
        }
        return new Vec3(0.0, 0.0, 0.0);
    }

    private static float inverter(Random r) {
        return r.nextFloat() * 2.0f - 1.0f;
    }

    private static float particleAmount(String type) {
        switch (type) {
            case "venom": 
            case "freeze": {
                return 0.3f;
            }
            case "spark": {
                return 0.6f;
            }
        }
        return 1.0f;
    }
}

