package net.m3tte.tactical_imbuements.procedures;

import java.util.LinkedList;
import net.m3tte.tactical_imbuements.EpicFight.ImbuementAnims;
import net.m3tte.tactical_imbuements.entity.FireflaskthrowableEntity;
import net.m3tte.tactical_imbuements.entity.FreezeFlaskThrowableEntity;
import net.m3tte.tactical_imbuements.entity.SparkFlaskThrowableEntity;
import net.m3tte.tactical_imbuements.entity.VenomFlaskThrowableEntity;
import net.m3tte.tactical_imbuements.init.TacticalImbuementsModEntities;
import net.m3tte.tactical_imbuements.init.TacticalImbuementsModItems;
import net.m3tte.tactical_imbuements.procedures.TickProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class UseImbueFlasks {

   private static void throwFlask(final AbstractArrow arrow, Player player, Level world) {
      LivingEntityPatch entitypatch = (LivingEntityPatch)player.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, (Direction)null).orElse((Object)null);
      entitypatch.playAnimationSynchronized(ImbuementAnims.THROW_FLASK, 0.0F);
      if(!world.m_5776_()) {
         world.m_5594_((Player)null, BlockPos.m_274561_(player.m_20185_(), player.m_20186_(), player.m_20189_()), SoundEvents.f_12437_, SoundSource.PLAYERS, 1.0F, 1.0F);
      }

      Projectile _entityToSpawn = ((<undefinedtype>)(new Object() {
         public Projectile getArrow(Level level, Entity shooter, float damage, int knockback) {
            arrow.m_5602_(shooter);
            arrow.m_36781_((double)damage);
            arrow.m_36735_(knockback);
            arrow.m_20225_(true);
            return arrow;
         }
      })).getArrow(world, player, 8.0F, 1);
      _entityToSpawn.m_6034_(player.m_20185_(), player.m_20188_() - 0.1D, player.m_20189_());
      _entityToSpawn.m_6686_(player.m_20154_().f_82479_, player.m_20154_().f_82480_, player.m_20154_().f_82481_, 1.0F, 0.1F);
      world.m_7967_(_entityToSpawn);
   }

   private static void applyImbuement(Level world, Player player, String imbueType, int time, String applySound, ItemStack potion, ItemStack weapon) {
      weapon.m_41784_().m_128359_("imbueType", imbueType);
      weapon.m_41784_().m_128347_("imbueCounter", (double)(player.f_19797_ + TickProcedure.defaultMaxTime));
      weapon.m_41784_().m_128347_("maxImbueTime", (double)TickProcedure.defaultMaxTime);
      potion.m_41774_(1);
      player.m_36356_(((Item)TacticalImbuementsModItems.FLASK.get()).m_7968_());
      world.m_5594_((Player)null, BlockPos.m_274561_(player.m_20185_(), player.m_20186_(), player.m_20189_()), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(applySound)), SoundSource.NEUTRAL, 1.0F, 1.0F);
   }

   public static void useImbuementFlask(Level world, String flaskType, Player player, InteractionHand useHand) {
      ItemStack itemStack = player.m_21120_(useHand);
      InteractionHand weaponHand;
      if(useHand == InteractionHand.OFF_HAND) {
         weaponHand = InteractionHand.MAIN_HAND;
      } else {
         weaponHand = InteractionHand.OFF_HAND;
      }

      ItemStack weaponItem = player.m_21120_(weaponHand);
      LivingEntityPatch entitypatch;
      if(weaponItem.m_41619_() && !world.m_5776_()) {
         itemStack.m_41774_(1);
         player.m_36335_().m_41524_(itemStack.m_41720_(), 40);
         entitypatch = null;
         byte var9 = -1;
         switch(flaskType.hashCode()) {
         case -1266402665:
            if(flaskType.equals("freeze")) {
               var9 = 3;
            }
            break;
         case 97513267:
            if(flaskType.equals("flame")) {
               var9 = 1;
            }
            break;
         case 109638365:
            if(flaskType.equals("spark")) {
               var9 = 4;
            }
            break;
         case 112093629:
            if(flaskType.equals("venom")) {
               var9 = 2;
            }
         }

         Object entitypatch1;
         switch(var9) {
         case 1:
         default:
            entitypatch1 = new FireflaskthrowableEntity((EntityType)TacticalImbuementsModEntities.FIREFLASKTHROWABLE.get(), world);
            break;
         case 2:
            entitypatch1 = new VenomFlaskThrowableEntity((EntityType)TacticalImbuementsModEntities.VENOMFLASKTHROWABLE.get(), world);
            break;
         case 3:
            entitypatch1 = new FreezeFlaskThrowableEntity((EntityType)TacticalImbuementsModEntities.FREEZEFLASKTHROWABLE.get(), world);
            break;
         case 4:
            entitypatch1 = new SparkFlaskThrowableEntity((EntityType)TacticalImbuementsModEntities.SPARKFLASKTHROWABLE.get(), world);
         }

         throwFlask((AbstractArrow)entitypatch1, player, world);
      } else if(weaponItem.m_204117_(ItemTags.create(new ResourceLocation("tactical_imbuements:applicable")))) {
         player.m_36335_().m_41524_(itemStack.m_41720_(), 200);
         entitypatch = (LivingEntityPatch)player.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY, (Direction)null).orElse((Object)null);
         entitypatch.playAnimationSynchronized(ImbuementAnims.APPLY_IMBUEMENT, 0.0F);
      }

   }

   public static void calculateImbuementUsage(Level world, Player player) {
      InteractionHand weaponHand;
      InteractionHand flaskHand;
      if(player.m_21120_(InteractionHand.MAIN_HAND).m_204117_(ItemTags.create(new ResourceLocation("tactical_imbuements:applicable")))) {
         weaponHand = InteractionHand.MAIN_HAND;
         flaskHand = InteractionHand.OFF_HAND;
      } else {
         if(!player.m_21120_(InteractionHand.OFF_HAND).m_204117_(ItemTags.create(new ResourceLocation("tactical_imbuements:applicable")))) {
            return;
         }

         weaponHand = InteractionHand.OFF_HAND;
         flaskHand = InteractionHand.MAIN_HAND;
      }

      ItemStack weaponItem = player.m_21120_(weaponHand);
      ItemStack itemStack = player.m_21120_(flaskHand);
      ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey(itemStack.m_41720_());
      if(resourceLocation != null) {
         String var7 = resourceLocation.m_135815_();
         byte var8 = -1;
         switch(var7.hashCode()) {
         case -610871825:
            if(var7.equals("flask_of_ice")) {
               var8 = 3;
            }
            break;
         case -407814318:
            if(var7.equals("flask_of_sparks")) {
               var8 = 4;
            }
            break;
         case 1360192919:
            if(var7.equals("flask_of_flame")) {
               var8 = 1;
            }
            break;
         case 1374773281:
            if(var7.equals("flask_of_venom")) {
               var8 = 2;
            }
         }

         switch(var8) {
         case 1:
         default:
            applyImbuement(world, player, "flame", TickProcedure.defaultMaxTime, "item.firecharge.use", itemStack, weaponItem);
            break;
         case 2:
            applyImbuement(world, player, "venom", TickProcedure.defaultMaxTime, "item.firecharge.use", itemStack, weaponItem);
            break;
         case 3:
            applyImbuement(world, player, "freeze", TickProcedure.defaultMaxTime, "item.firecharge.use", itemStack, weaponItem);
            break;
         case 4:
            applyImbuement(world, player, "spark", TickProcedure.defaultMaxTime, "item.firecharge.use", itemStack, weaponItem);
         }
      }

   }

   public static LinkedList getImbuements(LivingEntity entity) {
      LinkedList imbuements = new LinkedList();
      if(entity != null) {
         imbuements.add(entity.m_21205_().m_41784_().m_128461_("imbueType"));
         imbuements.add(entity.m_21206_().m_41784_().m_128461_("imbueType"));
      }

      return imbuements;
   }
}
